(*
  SG.pp
  Script Generator For GPRS Easy Connect
  Version 1.0.1 For Linux

  Copyright (C) 2003-2004 Gbor Pintr

  Script Generator is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Script Generator is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
*)

program SG;

uses Linux, Crt, SysUtils;

const
  //Chat szkripteket tartalmaz fjlok elrsi tvonala
  SG_GPRS_ScriptPath = '/usr/local/src/SG-1.0.1/bin/gprs-chat-scripts';
  SG_CDMA_ScriptPath = '/usr/local/src/SG-1.0.1/bin/cdma-chat-scripts';
  EC_GPRS_ScriptPath = '/usr/share/gprsec/tools/gprs-chat-scripts';
  EC_CDMA_ScriptPath = '/usr/share/gprsec/tools/cdma-chat-scripts';

  //APN listt tartalmaz fjlok elrsi tvonala
  SG_APN = '/usr/local/src/SG-1.0.1/bin/apn';
  EC_APN = '/usr/share/gprsec/tools/apn';

  //Nyelvi krnyezetet tartalmaz fjlok elrsi tvonala
  SG_HUN = '/usr/local/src/SG-1.0.1/lng/magyar.lng';
  EC_HUN = '/usr/share/gprsec/languages/magyar.lng';
  SG_ENG = '/usr/local/src/SG-1.0.1/lng/english.lng';
  EC_ENG = '/usr/share/gprsec/languages/english.lng';
  SG_ITA = '/usr/local/src/SG-1.0.1/lng/italian.lng';
  EC_ITA = '/usr/share/gprsec/languages/italian.lng';

var
  ChatScript: Array[0..255] of String;
  ScriptPath: String;
  ScriptType: (stGPRS, stCDMA);
  pFile: String;
  PhoneCnt, ProviderCnt: Integer;
  PhoneList: Array[0..255] of String;

  //Szlgltat adatai
  ProviderList: Array[0..255] of record
    ID,
    APN,
    UserName,
    Password,
    DNS1,
    DNS2: String;
  end;

  //Bekrend adatok
  Phone, Port, Speed, APN, UserName, Pwd: String;

{$I language.inc}
{$I utility.inc}

//Kszlkek kiolvassa
procedure ReadPhoneList;
var
  F: Text;
  strTemp: String;
  I: Integer;
begin
  Assign(F, ScriptPath);
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then
  begin
    FWriteln(lngString[28], [ScriptPath]);
    halt;
  end;

  I := 1;
  while not EOF(F) do
  begin
    Readln(F, strTemp);
    if copy(strTemp, 0, 1) = '[' then
    begin
      PhoneList[I] := copy(strTemp, 2, Length(strTemp)-2);
      inc(I);
    end;
  end;
  PhoneCnt := I;
  Close(F);
end;


//Tmogatott kszlkek listjnak megjelentse
procedure ShowPhoneList;
var
  I, J: Integer;
begin
  Clrscr;
  Writeln(lngString[10]);
  ReadPhoneList;

  I := 1;
  J := 0;
  while PhoneCnt - 1 >= I do
  begin
    Writeln(IntToStr(I):2,' = '+PhoneList[I]+';');
    inc(I);
    inc(J);
    if (J > 21) or (PhoneCnt - 1 < I) then
    begin
      J := 0;

      if I = PhoneCnt then
        Writeln(lngString[18])
      else
        Writeln(lngString[17]);

      if ReadKey in ['q','Q'] then halt;
      Clrscr;
    end;
  end;
end;


//Szolgltatk kiolvassa
procedure ReadAPNList;
var
  F: Text;
  strTemp, APNPath: String;
  I: Integer;
begin
  APNPath := SG_APN;
  if not FileExists(APNPath) then
    APNPath := EC_APN;

  Assign(F, APNPath);
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then
  begin
    FWriteln(lngString[28], [ScriptPath]);
    halt;
  end;

  I := -1;
  while not EOF(F) do
  begin
    Readln(F, strTemp);
    if (copy(strTemp, 0, 1) <> '#') and (copy(strTemp, 0, 1) <> #10) then begin
      ProviderList[I].ID := ExplodeAPN(strTemp, 0); //Szolgltat neve
      ProviderList[I].APN := ExplodeAPN(strTemp, 1); //APN
      ProviderList[I].UserName := ExplodeAPN(strTemp, 2); //Felhasznlnv
      ProviderList[I].Password := ExplodeAPN(strTemp, 3); //Jelsz
      ProviderList[I].DNS1 := ExplodeAPN(strTemp, 4); //DNS1
      ProviderList[I].DNS2 := ExplodeAPN(strTemp, 5); //DNS2
      inc(I);
    end;
  end;
  ProviderCnt := I;
  Close(F);
end;


//Tmogatott APN-ek listjnak megjelentse
procedure ShowAPNList;
var
  I, J: Integer;
begin
  Clrscr;
  Writeln(lngString[15]);
  ReadAPNList;

  I := 0;
  J := 0;
  while ProviderCnt - 1 >= I do
  begin
    inc(I);
    if ProviderList[I].ID <> '' then
    begin
      Writeln(IntToStr(I):2,' = '+ProviderList[I].ID+';');
      inc(J);
    end;
    if (J > 21) or (ProviderCnt - 1 < I) then
    begin
      J := 0;

      if I = ProviderCnt then
        Writeln(lngString[18])
      else
        Writeln(lngString[17]);

      if ReadKey in ['q','Q'] then halt;
      Clrscr;
    end;
  end;
end;


//Kszlk azonostjbl fjlnv ksztse
procedure CreateFileName(strPhone: String);
var
  strTemp: String;
  I: Integer;
begin
  strTemp := strPhone;

  for I := 1 to length(strTemp) do
  begin
    if copy(strTemp, I, 1) = ' ' then
      pFile := pFile + '-'
    else
    begin
      if copy(strTemp, I, 1) <> '*' then
      pFile := pFile + copy(strTemp, I, 1);
    end;
  end;

  pFile := LowerCase(pFile);
end;


//Kszlkhez tartoz parancsok beolvassa
function ReadChatScript(strPhone: String): Boolean;
var
  F: Text;
  strTemp: String;
  I: Integer;
begin
  ReadChatScript := False;

  Assign(F, ScriptPath);
  Reset(F);

  //Beolvass
  while not EOF(F) do
  begin
    Readln(F, strTemp);
    if LowerCase(strTemp) = LowerCase('['+strPhone+']') then
    begin
      ReadChatScript := True;
      I := 0;
      while (not EOF(F)) and (strTemp <> '') do
      begin
        Readln(F, strTemp);

        //2.0.0-nl jabb verzik valamint a korbbi verzikkal val kompatibilits miatt kell
        if not SearchString(strTemp, '.gif') then
        begin
          ChatScript[I] := strTemp;
          inc(I);
        end;

      end;
    end;
  end;

  Close(F);
end;


//Chat szkript fjlba rsa
procedure WriteChatScript(FileName: String);
var
  F: Text;
  I, J: Integer;
begin
  Assign(F, FileName);
  {$I-}
  Rewrite(F);
  {$I+}
  if IOResult <> 0 then
  begin
    FWriteln(lngString[29], [ScriptPath]);
    halt;
  end;
  Writeln(F, '#');
  Writeln(F, '# '+FString(lngString[31], [Phone]));
  Writeln(F, '#');
  Writeln(F, '# '+lngString[33]);
  Writeln(F, '# '+lngString[34]);
  Writeln(F, '#');
  Writeln(F, '# '+DateTimeToStr(Now));
  Writeln(F, '#'+#10);
  I := 0;
  while ChatScript[I] <> '' do
  begin
    //APN behelyettestse
    for J := 1 to length(ChatScript[I]) do
    begin
      if copy(ChatScript[I], J, 3) = '???' then
        ChatScript[I] := copy(ChatScript[I], 1, J-1) + APN + copy(ChatScript[I], J+3, length(ChatScript[I]));
    end;
    Writeln(F, ChatScript[I]);
    inc(I);
  end;
  Close(F);
end;


//pppd opcik fjlba rsa
procedure WritepppdScript(FileName: String);
var
  F: Text;
begin
  Assign(F, FileName);
  {$I-}
  Rewrite(F);
  {$I+}
  if IOResult <> 0 then
  begin
    FWriteln(lngString[29], [ScriptPath]);
    halt;
  end;

  case ScriptType of
    stGPRS: begin
      Writeln(F, '#!/bin/sh');
      Writeln(F, '#');
      Writeln(F, '# '+FString(lngString[37], [Phone]));
      Writeln(F, '#');
      Writeln(F, '# '+lngString[33]);
      Writeln(F, '# '+lngString[34]);
      Writeln(F, '#');
      Writeln(F, '# '+DateTimeToStr(Now));
      Writeln(F, '#'+#10);
      Writeln(F, '#'+lngString[39]+#10+'debug'+#10);
      Writeln(F, '#'+lngString[40]+#10+Port+#10);
      Writeln(F, '#'+lngString[41]+#10+Speed+#10);
      Writeln(F, '#'+lngString[42]+#10+'crtscts'+#10);
      Writeln(F, '#'+lngString[43]+#10+'modem'+#10);
      Writeln(F, '#'+lngString[44]+#10+'lock'+#10);
      Writeln(F, '#'+lngString[45]+#10+'receive-all'+#10);
      Writeln(F, '#'+lngString[46]+#10+'nopcomp'+#10);
      Writeln(F, '#'+lngString[47]+#10+'noaccomp'+#10);
      Writeln(F, '#'+lngString[48]+#10+'nomagic'+#10);
      Writeln(F, '#'+lngString[49]+#10+'noccp'+#10);
      Writeln(F, '#'+lngString[50]+#10+'novj'+#10);
      Writeln(F, '#'+lngString[51]+#10+'novjccomp'+#10);
      Writeln(F, '#'+lngString[52]+#10+'nodetach'+#10);
      Writeln(F, '#'+lngString[53]+#10+'noipdefault'+#10);
      Writeln(F, '#'+lngString[54]+#10+'defaultroute'+#10);
      Writeln(F, '#'+lngString[55]+#10+'usepeerdns'+#10);
      if UserName = '' then
        Writeln(F, '#'+lngString[56]+#10+'noauth'+#10)
      else
        Writeln(F, '#'+lngString[57]+#10+'user '+UserName+#10+'password '+Pwd+#10);

      Writeln(F, '#'+lngString[58]+#10+'connect ''/usr/sbin/chat -e -f ./'+pFile+'-connect -v'''+#10);
      Writeln(F, '#'+lngString[59]+#10+'disconnect ''/usr/sbin/chat -e -f ./disconnect -v'''+#10);
    end;
    stCDMA: begin
      Writeln(F, '#!/bin/sh');
      Writeln(F, '#');
      Writeln(F, '# '+FString(lngString[37], [Phone]));
      Writeln(F, '#');
      Writeln(F, '# '+lngString[33]);
      Writeln(F, '# '+lngString[34]);
      Writeln(F, '#');
      Writeln(F, '# '+DateTimeToStr(Now));
      Writeln(F, '#'+#10);
      Writeln(F, '#'+lngString[39]+#10+'debug'+#10);
      Writeln(F, '#'+lngString[40]+#10+Port+#10);
      Writeln(F, '#'+lngString[41]+#10+Speed+#10);
      Writeln(F, '#'+lngString[42]+#10+'crtscts'+#10);
      Writeln(F, '#'+lngString[44]+#10+'lock'+#10);
      Writeln(F, '#'+lngString[54]+#10+'defaultroute'+#10);
      Writeln(F, '#'+lngString[55]+#10+'usepeerdns'+#10);
      if UserName = '' then
        Writeln(F, '#'+lngString[56]+#10+'noauth'+#10)
      else
        Writeln(F, '#'+lngString[57]+#10+'user '+UserName+#10+'password '+Pwd+#10);

      Writeln(F, '#'+lngString[58]+#10+'connect ''/usr/sbin/chat -e -f ./'+pFile+'-connect -v'''+#10);
      Writeln(F, '#'+lngString[59]+#10+'disconnect ''/usr/sbin/chat -e -f ./disconnect -v'''+#10);
    end;
  end;

  Close(F);
end;


//Lekapcsoldst vgz szkriptfjl ksztse
procedure WriteDisconnectScript(FileName: String);
var
  F: Text;
begin
  if not FileExists(FileName) then
  begin
    Assign(F, FileName);
    {$I-}
    Rewrite(F);
    {$I+}
    if IOResult <> 0 then
    begin
      FWriteln(lngString[29], [ScriptPath]);
      halt;
    end;

    Writeln(F, '#');
    Writeln(F, '# '+FString(lngString[31], [Phone]));
    Writeln(F, '#');
    Writeln(F, '# '+lngString[33]);
    Writeln(F, '# '+lngString[34]);
    Writeln(F, '#');
    Writeln(F, '# '+DateTimeToStr(Now));
    Writeln(F, '#'+#10);
    Writeln(F, 'SAY "\n'+lngString[35]+'\n"');
    Writeln(F, '"" "\K"');
    Writeln(F, '"" "+++ATH"');
    Writeln(F, 'SAY "\n'+lngString[36]+'\n"');
    Close(F);
  end;
end;


//Adatbeolvass
procedure DataInput(strMsg: String; var strInput: String);
begin
  Writeln(#10+strMsg);
  Readln(strInput);
  if (strInput = 'q') or (strInput = 'Q') then halt;
end;


//Programverzi
procedure ProgramVer;
begin
  Writeln(lngString[1]+#10+lngString[2]+#10);
end;


//Segtsg
procedure ShowHelp;
begin
  Writeln('Usage: SG [options]');
  Writeln(#10+'Options:');
  Writeln('  -h, --help        Display this help');
  Writeln('  -m, --magyar      A program magyar nyelv');
  Writeln('  -e, --english     English version');
  Writeln('  -i, --italian     Italian version');
  Halt;
end;


//Kszlk bekrse
procedure GetPhone;
var
  PID: Byte;
  strInput: String;
begin
  Writeln(#10+lngString[6]+#10#10+lngString[7]+#10+lngString[8]);
  Writeln(#10+lngString[9]);
  if ReadKey in ['q','Q'] then halt;

  ShowPhoneList;

  ProgramVer;
  DataInput(lngString[11], strInput);

  if (strInput = 'q') or (strInput = 'Q') then halt;

  if (strInput = '') then
  begin
    Writeln(lngString[27]);
    halt;
  end else
    PID := StrToInt(strInput);

  case PID of
    0..255: Phone := PhoneList[PID];
  end;

  if not ReadChatScript(Phone) then
  begin
    Writeln(lngString[27]);
    halt;
  end;
end;


//Szolgltat bekrse
function GetProvider: Byte;
var
  AID: Byte;
  strInput: String;
begin
  Writeln(#10+lngString[12]+#10#10+lngString[13]+#10#10+lngString[14]);
  if ReadKey in ['q','Q'] then halt;

  ShowAPNList;

  ProgramVer;
  DataInput(lngString[16], strInput);

  if (strInput = 'q') or (strInput = 'Q') then halt;

  if (strInput = '') then
    AID := 0
  else
  begin
    AID := StrToInt(strInput);

    case AID of
      0..255: APN := ProviderList[AID].APN;
    end;
  end;

  GetProvider := AID;
end;


//Felhasznlnv s jelsz bekrse
procedure GetUP;
begin
  UserName := '';
  Pwd := '';
  DataInput(lngString[22], UserName);
  if UserName <> '' then
    DataInput(lngString[23], Pwd);
end;


//Port bekrse
procedure GetPort;
begin
  DataInput(lngString[19], Port);
end;


//Portsebessg bekrse
procedure GetPortSpeed;
begin
  DataInput(lngString[20], Speed);
end;


//Fjlok elksztse
procedure LastStep(DNS1, DNS2: String);
begin
  CreateFileName(Phone);
  WriteChatScript(pFile+'-connect');
  WriteDisconnectScript('disconnect');
  WritepppdScript(pFile);

  //DNS cmek kiiratsa
  if (DNS1 <> '') or (DNS2 <> '') then
  begin
    Writeln(#10+lngString[60]);
    FWriteln(lngString[61], [pFile]);
    Writeln(#10+lngString[63]+#10+DNS1+#10+DNS2+#10);
  end;

  FWriteln(lngString[24], [pFile, pFile]);
end;


var
  strInput: String;
  opLng: String;
  AID: Byte;
begin
  Clrscr;

  //Paramterek vizsglata
  if ParamCount = 0 then
  begin
    //A rendszer nyelvnek eltrolsa
    opLng := GetENV('LANG');

    //A rendszer nyelvnek megfelel nyelvi krnyezet beolvassa
    if opLng = 'hu_HU' then ReadLanguage(0) else
      if opLng = 'en_EN' then ReadLanguage(1) else
        if opLng = 'it_IT' then ReadLanguage(2) else
          if opLng = '' then ShowHelp;
  end else
  begin
    if (ParamStr(1) = '-m') or (ParamStr(1) = '--magyar') then ReadLanguage(0) else
      if (ParamStr(1) = '-e') or (ParamStr(1) = '--english') then ReadLanguage(1) else
        if (ParamStr(1) = '-i') or (ParamStr(1) = '--italian') then ReadLanguage(2) else ShowHelp;
  end;

  ProgramVer;
  Writeln(lngString[3]);
  Writeln(#10+lngString[4]);

  //Szkript tpus kivlasztsa (GPRS vagy CDMA)
  DataInput(lngString[5], strInput);

  if strInput = '' then
  begin
    Writeln(#10+lngString[27]);
    halt;
  end;

  ScriptPath := '';
  case strToInt(strInput) of
    1: begin //GPRS
      ScriptType := stGPRS;
      ScriptPath := SG_GPRS_ScriptPath;
      if not FileExists(SG_GPRS_ScriptPath) then
        ScriptPath := EC_GPRS_ScriptPath;

      GetPhone;
      AID := GetProvider;
    end;
    2: begin //CDMA
      ScriptType := stCDMA;
      ScriptPath := SG_CDMA_ScriptPath;
      if not FileExists(SG_CDMA_ScriptPath) then
        ScriptPath := EC_CDMA_ScriptPath;

      GetPhone;
    end;
    else begin
      Writeln(#10+lngString[27]);
      Halt;
    end;
  end;

  GetPort;
  GetPortSpeed;

  //GPRS szkript ksztse
  if ScriptType = stGPRS then begin
    if (APN = '') or (ProviderList[AID].APN = '') then
    begin
      DataInput(lngString[21], APN);
      GetUP;
    end else
    begin
      if (ProviderList[AID].UserName = '') or (ProviderList[AID].UserName = '(*)') or (ProviderList[AID].UserName = '(**)') then
      begin
        UserName := '';
        Pwd := '';
      end else
      begin
        if (ProviderList[AID].UserName = '(***)') or (ProviderList[AID].UserName = '(****)') then
        begin
          GetUP;
        end else
        begin
          UserName := ProviderList[AID].UserName;
          Pwd := ProviderList[AID].Password;
        end;
      end;
    end;

    if (Port = '') or (Speed = '') or (APN = '') then
      Writeln(lngString[26])
    else
      LastStep(ProviderList[AID].DNS1, ProviderList[AID].DNS2);
  end;

  //CDMA szkript ksztse
  if ScriptType = stCDMA then
  begin
    GetUP;
    if (Port = '') or (Speed = '') then
      Writeln(lngString[26])
    else
      LastStep(ProviderList[AID].DNS1, ProviderList[AID].DNS2);
  end;

end.
