(*
  language.inc
  This file is part of Script Generator.

  Copyright (C) 2003-2004 Gbor Pintr

  Script Generator is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Script Generator is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
*)

var
  lngString: Array[0..64] of String;

//Nyelvi krnyezet beolvassa
procedure ReadLanguage(LanguageID: Byte);
var
  F: Text;
  LanguageFile: Array[0..2] of String;
  strTemp: String;
  I: Integer;
begin
  LanguageFile[0] := SG_HUN;
  LanguageFile[1] := SG_ENG;
  LanguageFile[2] := SG_ITA;

  if not FileExists(LanguageFile[0]) then
    LanguageFile[0] := EC_HUN;

  if not FileExists(LanguageFile[1]) then
    LanguageFile[1] := EC_ENG;

  if not FileExists(LanguageFile[2]) then
    LanguageFile[1] := EC_ITA;

  Assign(F, LanguageFile[LanguageID]);
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then begin
    Writeln('Error: '+LanguageFile[LanguageID]+' file not found!');
    halt;
  end;
  I := 0;
  while not EOF(F) do begin
    Readln(F, strTemp);
    if Copy(strTemp, 0, 1) <> '#' then begin
      lngString[I] := strTemp;
      inc(I);
    end;
  end;
  Close(F);
end;
