(*
  utility.inc
  This file is part of Script Generator.

  Copyright (C) 2003-2004 Gbor Pintr

  Script Generator is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Script Generator is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
*)


//Karaktersorozat keresse karakterlncban
function SearchString(SourceStr, SearchStr: String): Boolean;
var
  SourceLen,
  SearchLen: Integer;
  l: Integer;
begin
  SearchString := False;

  SourceLen := length(SourceStr);
  SearchLen := length(SearchStr);

  for l := 0 to SourceLen do
  begin
    if copy(SourceStr, l, SearchLen) = SearchStr then
      SearchString := True;
  end;
end;


//APN karakterlnc sztbontsa
function ExplodeAPN(Str: String; Pos: Byte): String;
var
  l, c: Integer;
  SubPos: Array[0..31] of Byte;
begin
  ExplodeAPN := '';

  SubPos[0] := 0;
  c := 1;
  for l := 0 to length(Str) do
  begin
    if copy(Str, l, 1) = #9 then
    begin
      SubPos[c] := l;
      inc(c);
    end;
  end;

  ExplodeAPN := copy(Str, SubPos[Pos]+1, SubPos[Pos+1]-SubPos[Pos]-1);
end;


//Behelyettest fggvny az FWriteln s FString fggvnyhez
function FReplace(OStr, IStr: String): String;
var
  l: Integer;
  Pos: Integer;
begin
  Pos := 0;
  l := 0;

  if IStr <> '' then
  begin
    while (Pos = 0) and (length(OStr) >= l) do
    begin
      if Copy(OStr, l, 2) = '%s' then
        Pos := l-1;

      inc(l);
    end;

    FReplace := Copy(OStr, 0, Pos) + IStr + Copy(OStr, Pos + 3, length(OStr));
  end else
    FReplace := OStr;
end;


//Kirs behelyettestssel
procedure FWriteln(OStr: String; IStr: Array of String);
var
  l: Integer;
  OutStr: String;
begin
  OutStr := OStr;

  for l := 0 to high(IStr) do
    OutStr := FReplace(OutStr, IStr[l]);

  Writeln(OutStr);
end;


//Visszaads behelyettestssel
function FString(OStr: String; IStr: Array of String): String;
var
  l: Integer;
  OutStr: String;
begin
  OutStr := OStr;

  for l := 0 to high(IStr) do
    OutStr := FReplace(OutStr, IStr[l]);

  FString := OutStr;
end;
