(*
  Installer.pp
  Installer For GPRS Easy Connect
  Version 0.8.4

  Copyright (C) 2003-2004 Gabor Pinter

  GPRS EC Installer is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GPRS EC Installer is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
*)

program GPRS_EC_Installer;

uses Linux, Crt, glib, gdk, gtk, sysutils;

const
  LNG_F_HUN = 'magyar.lng';
  LNG_F_ENG = 'english.lng';

var
  LToC: Array[0..40] of String;
  LToG: Array[0..28] of pgchar;
  PP: String; //ProgramPath
  BackupConfig: Array[0..31] of String;
  InstallConfig: Array[0..31] of String;
  CleanUpConfig: Array[0..31] of String;
  RestoreConfig: Array[0..31] of String;
  UnInstallConfig: Array[0..31] of String;
  Step: Byte;

//Karaktersorozat keresese karakterlancban
function SearchString(SourceStr, SearchStr: String): Boolean;
var
  SourceLen,
  SearchLen: Integer;
  l: Integer;
begin
  SearchString := False;

  SourceLen := length(SourceStr);
  SearchLen := length(SearchStr);

  for l := 0 to SourceLen do
  begin
    if copy(SourceStr, l, SearchLen) = SearchStr then
      SearchString := True;
  end;
end;

//stdout beolvasasa
function ReadStdOut: String;
var
  F: Text;
  strIn,
  Return: String;
begin
  Return := ''; 

  Assign(F, PP + '/stdout');
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then begin
    Writeln(LToC[2]); //Hiba: nem olvashato a ./stdout!
    halt;
  end;
  while not EOF(F) do begin
    Readln(F, strIn);
    Return := Return + strIn;
  end;
  Close(F);

  ReadStdOut := Return; //Tartalom visszaadasa

  //Shell('rm ./stdout 2> /dev/null');
end;

//Kereses az stdout-ban
function SearchInStdOut(SearchStr: String): Boolean;
var
  StdOut: String;
begin
  SearchInStdOut := False;

  StdOut := ReadStdOut;

  if SearchString(StdOut, SearchStr) then
    SearchInStdOut := True;
end;

//Telepitendo fajlok visszaadasa
function ExplodeDestinationPath(Path: String): String;
var
  StrLen,
  lPos,
  l : Integer;
begin
  if (SearchString(Path, 'cp ')) or (SearchString(Path, 'ln ')) then
  begin
    StrLen := length(Path);

    //Utolso szokoz pozicioja
    for l := 0 to StrLen do
    begin
      if copy(Path, l, 1) = ' ' then
        lPos := l;
    end;

    ExplodeDestinationPath := copy(Path, lPos, StrLen);
  end else
    ExplodeDestinationPath := '';
end;

//Install.conf feldolgozasa
procedure ReadConfig;
var
  F: Text;
  strTemp: String;
  I: Integer;
begin
  Assign(F, PP + '/Install.conf');
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then
  begin
    Writeln('Error: Install.conf file not found!');
    halt;
  end;

  while not EOF(F) do
  begin
    Readln(F, strTemp);
    if Copy(strTemp, 0, 1) <> '#' then
    begin
      //Biztonsagi mentes beallitasai
      if SearchString(strTemp, '[Backup]') then
      begin
        I := 0;
        while (not EOF(F)) and (strTemp <> '') do
        begin
          Readln(F, strTemp);
          if Copy(strTemp, 0, 1) <> '#' then //Kommentelt sorokat nem dolgozza fel
          begin
            BackupConfig[I] := strTemp;
            Inc(I);
          end;
        end;
      end;

      //Telepites beallitasai
      if SearchString(strTemp, '[Install]') then
      begin
        I := 0;
        while (not EOF(F)) and (strTemp <> '') do
        begin
          Readln(F, strTemp);
          if Copy(strTemp, 0, 1) <> '#' then
          begin
            InstallConfig[I] := strTemp;
            Inc(I);
          end;
        end;
      end;

      //Tisztogatas beallitasai
      if SearchString(strTemp, '[CleanUp]') then
      begin
        I := 0;
        while (not EOF(F)) and (strTemp <> '') do
        begin
          Readln(F, strTemp);
          if Copy(strTemp, 0, 1) <> '#' then
          begin
            CleanUpConfig[I] := strTemp;
            Inc(I);
          end;
        end;
      end;

      //Visszaallitas beallitasai
      if SearchString(strTemp, '[Restore]') then
      begin
        I := 0;
        while (not EOF(F)) and (strTemp <> '') do
        begin
          Readln(F, strTemp);
          if Copy(strTemp, 0, 1) <> '#' then
          begin
            RestoreConfig[I] := strTemp;
            Inc(I);
          end;
        end;
      end;

      //Eltavolitas beallitasai
      if SearchString(strTemp, '[UnInstall]') then
      begin
        I := 0;
        while (not EOF(F)) and (strTemp <> '') do
        begin
          Readln(F, strTemp);
          if Copy(strTemp, 0, 1) <> '#' then
          begin
            UnInstallConfig[I] := strTemp;
            Inc(I);
          end;
        end;
      end;

    end;
  end;

  Close(F);
end;

//Nyelvi kornyezet beolvasasa
procedure ReadLanguage(LanguageID: Byte);
var
  F: Text;
  LanguageFile: Array[0..2] of String;
  strTemp: String;
  I: Integer;
begin
  LanguageFile[0] := LNG_F_HUN;
  LanguageFile[1] := LNG_F_ENG;
   
  Assign(F, PP + '/' + LanguageFile[LanguageID]);
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then begin
    Writeln('Error: '+ PP + '/' + LanguageFile[LanguageID]+' file not found!');
    halt;
  end;
  
  while not EOF(F) do begin
    Readln(F, strTemp);
    
    if strTemp = '[LToC]' then //Konzolos verzio nyelvi kornyezete
    begin
      I := 0;
      while (not EOF(F)) or (Copy(strTemp, 0, 1) = '[') do
      begin
        if Copy(strTemp, 0, 1) <> '#' then begin
          LToC[I] := strTemp;
          inc(I);
        end;
        Readln(F, strTemp);
      end;
    end;
  end;

  Reset(F);
          
  while not EOF(F) do begin
    Readln(F, strTemp);
    
    if strTemp = '[LToG]' then //Grafikus verzio nyelvi kornyezete
    begin
      I := 0;
      while (not EOF(F)) do
      begin
        if Copy(strTemp, 0, 1) <> '#' then begin
          LToG[I] := StrAlloc(length(strTemp)+1);
          StrPCopy(LToG[I], strTemp);     
          inc(I);
        end;
        Readln(F, strTemp);
      end;
    end;
  end;
  
  Close(F);
end;

//Futo GPRS EC keresese
function SR_GPRS_EC: Boolean;
var
  StdOut: String;
begin
  SR_GPRS_EC := False;

  Shell('ps ax -o command | grep gprsec > ./stdout');
  StdOut := ReadStdOut;

  if (SearchString(StdOut, '/usr/bin/gprsec')) or (SearchString(StdOut, '/usr/local/bin/gprsec')) then
    SR_GPRS_EC := True;
end;

//Tisztogatas a telepito utan
procedure CleanUp;
var
  I: Byte;
begin
  I := 0;
  repeat
    if CleanUpConfig[I] <> '' then
      Shell(CleanUpConfig[I] + ' 2> ./stdout');
    Inc(I);
  until CleanUpConfig[I] = '';

  Shell('rm ./stdout');
end;

//Biztonsagi mentes keszitese
procedure Backup;
var
  I: Byte;
begin
  I := 0;
  repeat
    if BackupConfig[I] <> '' then
    begin
      Shell(BackupConfig[I]+' 2> ./stdout');
    end;
    Inc(I);
  until BackupConfig[I] = '';
end;

//Korabbi verzio visszaallitasa
procedure Restore;
var
  I: Byte;
begin
  I := 0;
  repeat
    if RestoreConfig[I] <> '' then
    begin
      Shell(RestoreConfig[I]+' 2> ./stdout');
    end;
    Inc(I);
  until RestoreConfig[I] = '';
end;


{ *** Grafikus felhasznaloi interfeszhez szukseges eljarasok/fuggvenyek *** }

var
  MainWindow,
  mTable, Table1, Table1_1, Table2, Table2_1, Table3, Table3_1, Table4, Table4_1,
  NoteBook,
  LogoFrame, MessageFrame,
  TextBox,
  VScrollBar,
  lTitle, lTitleNote, lLogo, lWelcome, lWelcomeError, lWelcomeNote,
  Separator,
  depList, statList,
  btnAgree, btnBack, btnNext, btnFinish, btnQuit: pGtkWidget; //GtkWidget, a widgetek tarolo tipusa
  LabelStyle: PGtkStyle;

  //Logo
  LogoPixMap: pGdkPixmap;
  LogoMask: pGdkBitmap;
  LogoStyle: pGtkStyle;
  Logo: pGtkWidget;

  bBackup: Boolean;
  
//Uzenet megjelenitese egy kulon ablakban
procedure ShowMessage(Message: PChar);
var
  MessageWindow, lMessage, btnOk, mTable: pGtkWidget;
begin
  MessageWindow := gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(MessageWindow), 10); //Ablak keretszelessegenek beallitasa
  gtk_widget_set_usize(PGtkWIDGET(MessageWindow), 320, 120); //Ablak meretenek beallitasa
  gtk_window_set_title(PGtkWINDOW(MessageWindow), LToG[1]); //GPRS Easy Connect Telepito

  mTable := gtk_table_new(480, 640, True);
  gtk_container_add(GTK_CONTAINER(MessageWindow), mTable);

  lMessage := gtk_label_new(Message);
  gtk_table_attach_defaults(GTK_TABLE(mTable), lMessage, 0, 300, 0, 70);
  gtk_label_set_justify(GTK_LABEL(lMessage), GTK_JUSTIFY_LEFT); //Szoveg balra igazitasa
  gtk_label_set_line_wrap(GTK_LABEL(lMessage), True);

  btnOk := gtk_button_new_with_label(LToG[17]); //Ok
  gtk_table_attach_defaults(GTK_TABLE(mTable), btnOk, 200, 300, 75, 100);
  gtk_signal_connect_object(PgtkObject(btnOk), 'clicked', GTK_SIGNAL_FUNC(@gtk_widget_destroy), PGTKOBJECT(MessageWindow)); //Ablak bezarasa

  gtk_widget_show_all(MessageWindow);
end;

//Kilepes a GUI-bol
procedure destroy(widget : pGtkWidget ; data: pgpointer ); cdecl;
begin
  gtk_main_quit();
end;

//GUI elso lepes -> Udvozlo kepernyo
procedure GUI_Step1;
begin
  gtk_widget_hide(btnBack); //Vissza gomb elrejtese
end;

//GUI masodik lepes -> GNU GPL elfogadasa
procedure GUI_Step2;
begin
  //Vissza es Tovabb gombok mutatasa
  gtk_widget_show(btnBack);
  gtk_widget_show(btnNext);
end;

//GUI harmadik lepes -> Fuggosegek ellenorzese
function GUI_Step3: Boolean;
var
  Items: Array[0..1, 0..1] of pgchar;
begin
  GUI_Step3 := True; //Minden rendben

  gtk_clist_clear(PGtkCList(depList)); //Lista tartalmanak torlese

  //pppd ellenorzese
  Items[0,0] := 'pppd - (Point to Point Protocol daemon)';
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "pppd" -maxdepth 1 > ./stdout'); //Kereses es eredmeny kiirasa a ./stdout fajlba

  if not SearchInStdOut('pppd') then //Ha nem talalhato akkor hiba
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]); //Eredmeny hozzafuzese a listahoz

  //chat ellenorzese
  Items[0,0] := 'chat';
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "chat" -maxdepth 1 > ./stdout');

  if not SearchInStdOut('chat') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]);

  //perl ellenorzese
  Items[0,0] := 'perl - (Practical Extraction and Report Language)';
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "perl" -maxdepth 1 > ./stdout');

  if not SearchInStdOut('perl') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]);

  //Tk ellenorzese
  Items[0,0] := 'Tk - (Graphical User Interface ToolKit for Perl)';
  Shell('perl -e ''use Tk;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]);

  //LWP::Simple modul ellenorzese
  Items[0,0] := 'LWP::Simple';
  Shell('perl -e ''use LWP::Simple;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]);

  //HTML::Parser modul ellenorzese
  Items[0,0] := 'HTML::Parser';
  Shell('perl -e ''use HTML::Parser;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]);

  //URI modul ellenorzese
  Items[0,0] := 'URI - (Uniform Resource Identifier)';
  Shell('perl -e ''use URI;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.

  gtk_clist_append(PGtkCList(depList), @Items[0]);

  //wget ellenorzese
  Items[0,0] := 'wget - (GNU Wget)';
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "wget" -maxdepth 1 > ./stdout');

  if not SearchInStdOut('wget') then
  begin
    Items[0,1] := LToG[18]; //Hiba.
    GUI_Step3 := False;
  end
  else
    Items[0,1] := LToG[19]; //Rendben.
    
  gtk_clist_append(PGtkCList(depList), @Items[0]);
  
  Items[0,0] := LToG[20]; //Korabbi verzio keresese
  
  Shell('find /usr/bin /usr/local/bin -name "gprsec" -maxdepth 1 > ./stdout');
  
  if SearchInStdOut('gprsec') then
  begin
    bBackup := True;
    Items[0,1] := LToG[19]; //Rendben
    gtk_clist_append(PGtkCList(depList), @Items[0]);

    Items[0,0] := LToG[21]; //Biztonsagi mentes keszitese
    Backup; //Biztonsagi mentes
    Items[0,1] := LToG[19]; //Rendben
    gtk_clist_append(PGtkCList(depList), @Items[0]);
  end else
  begin
    Items[0,1] := LToG[19]; //Rendben
    gtk_clist_append(PGtkCList(depList), @Items[0]);
  end;
end;

//GUI negyedik lepes -> Fajlok masolasa
function GUI_Step4: Boolean;
var
  Items: Array[0..1, 0..1] of pChar;
  SR: Longint;
  I: Byte;
begin
  GUI_Step4 := True;

  ReadConfig; //Telepiteshez szukseges muveletek beolvasasa
  gtk_clist_clear(PGtkCList(statList)); //Lista tartalmanak torlese

  I := 0;
  repeat
    if InstallConfig[I] <> '' then begin
      //Muvelet beszurasa a lista elso oszlopaba
      Items[0,0] := StrAlloc(length(InstallConfig[I]) - 1);
      StrPCopy(Items[0,0], InstallConfig[I]);

      //SR := Shell(InstallConfig[I] + ' 2> ./stdout'); //Muvelet vegrehajtasa
      SR := Shell(InstallConfig[I]); //Muvelet vegrehajtasa visszajelzessel
      //SR := 0; //<- Teszteleshez (Fix.tv - LinuxPortal)

      if SR <> 0 then //Hiba a muvelet vegrehajtasa soran
      begin
        Items[0,1] := LToG[18]; //Hiba.
        GUI_Step4 := False;
        InstallConfig[I+1] := ''; //Kovetkezo muveletet mar nem hajtja vegre!
      end
      else
        Items[0,1] := LToG[19]; //Rendben.

      gtk_clist_append(PGtkCList(statList), @Items[0]); //Vegeredmeny feltoltese a listaba
    end;
    Inc(I);
  until InstallConfig[I] = '';

  gtk_widget_hide(btnNext); //Tovabb gomb elrejtese
  
  if GUI_Step4 then
  begin
    gtk_widget_hide(btnBack);
    gtk_widget_hide(btnQuit);

    btnFinish := gtk_button_new_with_label(LToG[16]); //Befejez
    gtk_table_attach_defaults(GTK_TABLE(mTable), btnFinish, 515, 615, 435, 460);
    gtk_signal_connect(GTK_OBJECT(btnFinish), 'clicked', GTK_SIGNAL_FUNC(@gtk_main_quit), nil);
    gtk_widget_show(btnFinish); //Befejez gomb megjelenitese
  end
  else
  begin
    if bBackup then
    begin
      Items[0,0] := LToG[27]; //Korabbi verzio keresese
      Restore;
      Items[0,1] := LToG[19]; //Rendben.
      gtk_clist_append(PGtkCList(statList), @Items[0]);
    end; 
  end;
end;

//GUI negyedik lepes -> Befejezes
procedure GUI_Step5;
begin
end;

procedure CallBack(Widget: PGtkWidget; Data: pGPointer); CDECL;
begin
  //Writeln(PChar(Data), ' gomb lett lenyomva.');

  if PChar(Data) = 'btnBack' then
    Dec(Step);

  if PChar(Data) = 'btnNext' then
    Inc(Step);

  if Step > 4 then Step := 4;
  if Step < 0 then Step := 0;

  //Writeln('Lepes: ', Step);

  case Step of
    0: GUI_Step1;
    1: GUI_Step2;
    2:
    begin
      if active(GTK_CHECK_BUTTON(btnAgree)^.toggle_button) <> 0 then
      begin
        if not GUI_Step3 then //Hiba eseten Tovabb lepes tiltasa
         gtk_widget_hide(btnNext)
        else
         gtk_widget_show(btnNext); //Ha nincs hiba akkor pedig engedelyezese (a kovetkezo lepesnel levo esetleges tiltas miatt)
      end
      else
      begin
        Dec(Step);
        if active(GTK_CHECK_BUTTON(btnAgree)^.toggle_button) = 0 then
        begin
          ShowMessage(LToG[26]); //A program telepitesehez el kell fogadnod a Licensz szerzodest.
        end;
      end;
    end;
    3: GUI_Step4;
    4: GUI_Step5;
  end;

  gtk_notebook_set_page(pGtkNoteBook(NoteBook), Step);
end;

procedure GUI;
var
  depTitles: Array[0..1] of pgchar;
  statTitles: Array[0..1] of pgchar;
  l: PChar;
  InStr: String;
  S: String;
  LogoPath: pgchar;
begin
  LogoPath := StrAlloc(length(PP + '/logo.xpm') + 1);
  StrPCopy(LogoPath, PP + '/logo.xpm'); 
  
  Step := 0; //Telepitesi lepes beallitasa (0 = udvozles)

  //Tablazatok fejlece
  depTitles[0] := LToG[22]; //Fuggosegek
  depTitles[1] := LToG[23]; //Eredmeny
  statTitles[0] := LToG[24]; //Muvelet
  statTitles[1] := LToG[25]; //Eredmeny
  
  //Ezt minden GTK applikacio meghivja. A parancssori parametereket atveszi es visszater a programba.
  gtk_init(@argc, @argv);
  
  //Uj ablak letrehozasa
  MainWindow := gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(MainWindow), 10); //Ablak keretszelessegenek beallitasa
  gtk_widget_set_usize(PGtkWIDGET(MainWindow), 640, 480); //Ablak meretenek beallitasa
  gtk_window_set_title(PGtkWINDOW(MainWindow), LToG[1]); //GPRS Easy Connect Telepito

  //Destroy esemeny hozzakapcsolasa szignalhoz
  gtk_signal_connect(pGTKOBJECT(MainWindow), 'destroy', GTK_SIGNAL_FUNC(@destroy), NULL);

  //*** Fo tabla ***
  mTable := gtk_table_new(480, 640, True);
  gtk_container_add(GTK_CONTAINER(MainWindow), mTable);

  //NoteBook
  NoteBook := gtk_notebook_new();
  gtk_table_attach_defaults(GTK_TABLE(mTable), NoteBook, 0, 620, 0, 420);
  gtk_notebook_set_show_tabs(pGtkNoteBook(NoteBook), False); //Fulek elrejtese
  gtk_notebook_set_show_border(pGtkNoteBook(NoteBook), False); //Keret elrejtese

  //Logo es udvozlo szoveg
  Table1 := gtk_table_new(480, 640, True);
  gtk_notebook_append_page(pGtkNoteBook(NoteBook), Table1, nil);

    //*** Logo & Message Box ***
    LogoFrame := gtk_frame_new(nil); //Logo frame
    gtk_table_attach_defaults(GTK_TABLE(Table1), LogoFrame, 0, 200, 0, 420);

      LogoStyle := gtk_widget_get_style(LogoFrame);
      LogoPixMap := gdk_pixmap_create_from_xpm(LogoFrame^.window, @LogoMask, @LogoStyle^.bg[GTK_STATE_NORMAL], LogoPath); //Pixmap betoltese XPM fajlbol

      Logo := gtk_pixmap_new(LogoPixMap, LogoMask); //Uj pixmap
      gtk_container_add(GTK_CONTAINER(LogoFrame), Logo);

    MessageFrame := gtk_frame_new(nil); //Message frame
    gtk_table_attach_defaults(GTK_TABLE(Table1), MessageFrame, 205, 620, 0, 420);

      Table1_1 := gtk_table_new(10, 10, True);
      gtk_container_add(GTK_CONTAINER(MessageFrame), Table1_1);

      lWelcome := gtk_label_new(LToG[2]); //Udvozol a GPRS Easy Connect 2.5.1 Telepito!
      //gtk_label_set_justify(GTK_LABEL(lWelcome), GTK_JUSTIFY_FILL);
      gtk_label_set_line_wrap(GTK_LABEL(lWelcome), True); //Sortores
      gtk_table_attach_defaults(GTK_TABLE(Table1_1), lWelcome, 0, 10, 0, 2); //Tablazatban megjelenites

      //Futo GPRS EC keresese
      if SR_GPRS_EC then
      begin
        lWelcomeError := gtk_label_new(LToG[3]); //A Telepito talalt egy futo GPRS EC peldanyt. A telepites folytatasa elott ezt mindenkepp zard be!
        gtk_label_set_justify(GTK_LABEL(lWelcomeError), GTK_JUSTIFY_FILL);
       
        LabelStyle := gtk_style_copy(gtk_widget_get_style(lWelcomeError));
        with LabelStyle^.fg[GTK_STATE_NORMAL] do
        begin
          pixel:=0;
          red:=$ffff;
          blue:=0;
          green:=0;
        end;
        gtk_widget_set_style(lWelcomeError, LabelStyle);
        
        gtk_label_set_line_wrap(GTK_LABEL(lWelcomeError), True);
        gtk_table_attach_defaults(GTK_TABLE(Table1_1), lWelcomeError, 0, 10, 2, 4); //Tablazatban megjelenites        
      end;
                  
      lWelcomeNote := gtk_label_new(LToG[5]); //A telepites megkezdesehez kattints a Tovabb gombra, a befejezeshez a Kilepes gombra.
      gtk_label_set_line_wrap(GTK_LABEL(lWelcomeNote), True);    
      gtk_table_attach_defaults(GTK_TABLE(Table1_1), lWelcomeNote, 0, 10, 8, 10); //Tablazatban megjelenites     

  Table2 := gtk_table_new(480, 640, True);
  gtk_notebook_append_page(pGtkNoteBook(NoteBook), Table2, nil);

    Table2_1 := gtk_table_new(100, 100, True);
    gtk_table_attach_defaults(GTK_TABLE(Table2), Table2_1, 0, 620, 0, 420);

      //Licenc felirat
      lTitle := gtk_label_new(LToG[6]); //Altalanos Kozreadasi Feltetelek
      gtk_table_attach_defaults(GTK_TABLE(Table2_1), lTitle, 0, 100, 0, 4);
      gtk_label_set_justify(GTK_LABEL(lTitle), GTK_JUSTIFY_LEFT); //Balra igazitas

      lTitleNote := gtk_label_new(LToG[7]); //A program telepitesehez el kell fogadnod az alabbiakban leirtakat.
      gtk_table_attach_defaults(GTK_TABLE(Table2_1), lTitleNote, 0, 100, 5, 9);
      //gtk_label_set_justify(GTK_LABEL(lTitleNote), GTK_JUSTIFY_LEFT); //Balra igazitas

      //Elvalaszto
      Separator := gtk_hseparator_new();
      gtk_table_attach(GTK_TABLE(Table2_1), Separator, 0, 100, 10, 12, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);

      //Szovegdoboz
      TextBox := gtk_text_new(nil, nil);
      gtk_table_attach(GTK_TABLE(Table2_1), TextBox, 0, 97, 14, 95, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);

      VScrollBar := gtk_vscrollbar_new(GTK_TEXT(TextBox)^.vadj);
      gtk_table_attach(GTK_TABLE(Table2_1), VScrollBar, 98, 100, 14, 95, GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);

      btnAgree := gtk_check_button_new_with_label(LToG[8]); //A leirtakat tudomasul vettem es elfogadom
      gtk_table_attach(GTK_TABLE(Table2_1), btnAgree, 0, 50, 96, 100, GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);

  Table3 := gtk_table_new(480, 640, True);
  gtk_notebook_append_page(pGtkNoteBook(NoteBook), Table3, nil);

    Table3_1 := gtk_table_new(100, 100, True);
    gtk_table_attach_defaults(GTK_TABLE(Table3), Table3_1, 0, 620, 0, 420);

      //Fuggosegek ellenorzese felirat
      lTitle := gtk_label_new(LToG[9]); //Fuggosegek ellenorzese
      gtk_table_attach_defaults(GTK_TABLE(Table3_1), lTitle, 0, 100, 0, 4);
      //gtk_label_set_justify(GTK_LABEL(lTitle), GTK_JUSTIFY_LEFT); //Balra igazitas

      lTitleNote := gtk_label_new(LToG[10]); //A program telepitesehez szukseg van az alabbi modulokra/programokra.
      gtk_table_attach_defaults(GTK_TABLE(Table3_1), lTitleNote, 0, 100, 5, 9);
      //gtk_label_set_justify(GTK_LABEL(lTitleNote), GTK_JUSTIFY_LEFT); //Balra igazitas

      //Elvalaszto
      Separator := gtk_hseparator_new();
      gtk_table_attach(GTK_TABLE(Table3_1), Separator, 0, 100, 10, 12, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);

      //Lista
      depList := gtk_clist_new_with_titles(2, depTitles);
      gtk_table_attach(GTK_TABLE(Table3_1), depList, 0, 100, 14, 95, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);
      gtk_clist_set_column_width(PGtkCLIST(depList), 0, 500); //Elso oszlop szelessegenek beallitasa

  Table4 := gtk_table_new(480, 640, True);
  gtk_notebook_append_page(pGtkNoteBook(NoteBook), Table4, nil);

    Table4_1 := gtk_table_new(100, 100, True);
    gtk_table_attach_defaults(GTK_TABLE(Table4), Table4_1, 0, 620, 0, 420);

      //Telepites ellenorzese felirat
      lTitle := gtk_label_new(LToG[11]); //Telepites
      gtk_table_attach_defaults(GTK_TABLE(Table4_1), lTitle, 0, 100, 0, 4);
      //gtk_label_set_justify(GTK_LABEL(lTitle), GTK_JUSTIFY_LEFT); //Balra igazitas

      lTitleNote := gtk_label_new(LToG[12]); //A program futtatasahoz szukseges fajlok masolasa.
      gtk_table_attach_defaults(GTK_TABLE(Table4_1), lTitleNote, 0, 100, 5, 9);
      //gtk_label_set_justify(GTK_LABEL(lTitleNote), GTK_JUSTIFY_LEFT); //Balra igazitas

      //Elvalaszto
      Separator := gtk_hseparator_new();
      gtk_table_attach(GTK_TABLE(Table4_1), Separator, 0, 100, 10, 12, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);

      //Lista
      statList := gtk_clist_new_with_titles(2, statTitles);
      gtk_table_attach(GTK_TABLE(Table4_1), statList, 0, 100, 14, 95, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, GTK_EXPAND OR GTK_SHRINK OR GTK_FILL, 0, 0);
      gtk_clist_set_column_width(PGtkCLIST(statList), 0, 500); //Elso oszlop szelessegenek beallitasa

  { Elvalaszto }

  Separator := gtk_hseparator_new();
  gtk_table_attach_defaults(GTK_TABLE(mTable), Separator, 0, 615, 423, 427);

  { Gombok }

  //Vissza
  btnBack := gtk_button_new_with_label(LToG[13]); //< Vissza
  gtk_table_attach_defaults(GTK_TABLE(mTable), btnBack, 205, 305, 435, 460);
  gtk_signal_connect(GTK_OBJECT(btnBack), 'clicked', GTK_SIGNAL_FUNC(@CallBack), PChar('btnBack'));

  //Kovetkezo
  btnNext := gtk_button_new_with_label(LToG[14]); //Tovabb >
  gtk_table_attach_defaults(GTK_TABLE(mTable), btnNext, 315, 415, 435, 460);
  gtk_signal_connect(GTK_OBJECT(btnNext), 'clicked', GTK_SIGNAL_FUNC(@CallBack), PChar('btnNext'));
  
  //Kilepes
  btnQuit := gtk_button_new_with_label(LToG[15]); //Kilep
  gtk_table_attach_defaults(GTK_TABLE(mTable), btnQuit, 515, 615, 435, 460);
  gtk_signal_connect_object(PgtkObject(btnQuit), 'clicked', GTK_SIGNAL_FUNC(@gtk_widget_destroy), PGTKOBJECT(MainWindow));


  gtk_widget_show_all(MainWindow); //Ablak es tartalmanak mutatasa
  gtk_widget_hide(btnBack); //Vissza gomb elrejtese, mivel elso lepesben meg nincs ra szukseg

  { GNU GPL betoltese }
  l := '';
  {$I-}
  Assign(Input, PP + '/COPYING');
  {$I+}
  Reset(Input);

  if IOResult = 0 then //Nincs hiba
  begin
    while not EOF(Input) do //Beolvasas
    begin
      Readln(Input, InStr);
      S := InStr + #10;
      l := StrAlloc(length(S));
      StrPCopy(l, S);     
      gtk_text_insert(GTK_TEXT(TextBox), nil, nil, nil, l, length(S)); //Beszuras a TextBox-ba
    end;
    Close(Input);
  end;

  if getuid <> 0 then //ROOT jog ellenorzese
  begin
    lWelcomeError := gtk_label_new(LToG[4]); //Te nem lenni ROOT! Csak akkor folytasd a telepitest ha van irasi jogosultsagod a /usr konyvtarhoz! Egyebkent lepj ki a Telepitobol es inditsd el ROOT-kent.
    
    LabelStyle := gtk_style_copy(gtk_widget_get_style(lWelcomeError));
    with LabelStyle^.fg[GTK_STATE_NORMAL] do
    begin
      pixel:=0;
      red:=$ffff;
      blue:=0;
      green:=0;
    end;
    gtk_widget_set_style(lWelcomeError, LabelStyle);
    
    gtk_label_set_line_wrap(GTK_LABEL(lWelcomeError), True);
    
    if SR_GPRS_EC then
      gtk_table_attach_defaults(GTK_TABLE(Table1_1), lWelcomeError, 0, 10, 3, 8) //Tablazatban megjelenites
    else
      gtk_table_attach_defaults(GTK_TABLE(Table1_1), lWelcomeError, 0, 10, 2, 8); //Tablazatban megjelenites
      
    gtk_widget_show(lWelcomeError);        
    gtk_widget_hide(lWelcomeNote);
    gtk_widget_hide(btnNext); //Tovabb gomb elrejtese
  end;
  
  
  gtk_main(); 
end;

{ *** Grafikus felhasznaloi interfeszhez szukseges eljarasok/fuggvenyek vege *** }


{ *** Karakteres felhasznaloi interfeszhez szukseges eljarasok/fuggvenyek *** }

//Fuggosegek ellenorzese
procedure CheckDependencies;
begin
  Writeln(LToC[3]); //Fuggosegek ellenorzese...

  //pppd ellenorzese
  Write('  pppd');
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "pppd" -maxdepth 1 > ./stdout'); //Kereses es eredmeny kiirasa a ./stdout fajlba

  if not SearchInStdOut('pppd') then //Ha nem talalhato, akkor hiba
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[9]+#10+LToC[10]+#10+LToC[11]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //chat ellenorzese
  Write('  chat');
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "chat" -maxdepth 1 > ./stdout');

  if not SearchInStdOut('chat') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[9]+#10+LToC[10]+#10+LToC[11]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //perl ellenorzese
  Write('  perl');
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "perl" -maxdepth 1 > ./stdout');

  if not SearchInStdOut('perl') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[6]+#10+LToC[7]+#10+LToC[8]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //Tk ellenorzese
  Write('  Tk');
  Shell('perl -e ''use Tk;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[12]+#10+LToC[13]+#10+LToC[14]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //LWP::Simple modul ellenorzese
  Write('  LWP::Simple');
  Shell('perl -e ''use LWP::Simple;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[15]+#10+LToC[16]+#10+LToC[17]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //HTML::Parser modul ellenorzese
  Write('  HTML::Parser');
  Shell('perl -e ''use HTML::Parser;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[15]+#10+LToC[16]+#10+LToC[17]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //URI modul ellenorzese
  Write('  URI');
  Shell('perl -e ''use URI;'' 2> ./stdout');

  if SearchInStdOut('Can''t locate') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[18]+#10+LToC[19]+#10+LToC[20]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]

  //wget ellenorzese
  Write('  Wget');
  Shell('find /bin /usr/bin /usr/local/bin /usr/sbin -name "wget" -maxdepth 1 > ./stdout');

  if not SearchInStdOut('wget') then
  begin
    Writeln(LToC[5]); //[Hiba]
    Writeln(#10+LToC[21]+#10+LToC[22]+#10+LToC[23]); //Javaslat
    halt;
  end;
  Writeln(LToC[4]); //[OK]
end;

//Fajlok masolasa
procedure Install;
var
  SR: Longint;
  I: Byte;
  Dp: String;
begin
  I := 0;
  repeat
    if InstallConfig[I] <> '' then begin
      SR := Shell(InstallConfig[I]+' 2> ./stdout');

      //Cel kiiratasa
      Dp := ExplodeDestinationPath(InstallConfig[I]);
      if Dp <> '' then
        Writeln(Dp);

      if SR <> 0 then begin
        Writeln(LToC[31]+#10); //Hiba!
        Writeln(LToC[36]+#10+InstallConfig[I]+#10); //A hiba a kovetkezo parancs futtatasakor jelentkezett:
        Write(LToC[30]); //Korabbi verzio visszaallitasa...
        Restore;
        Writeln(LToC[32]); //Kesz!
        halt;
      end;
    end;
    Inc(I);
  until InstallConfig[I] = '';
end;

//Eltavolitas
procedure UnInstall;
var
  SR: Longint;
  I: Byte;
begin
  Clrscr;
  Writeln(LToC[1]+#10); //GPRS Easy Connect Telepito

  Write(LToC[35]); //Eltavolitas...

  I := 0;
  repeat
    if UnInstallConfig[I] <> '' then begin
      SR := Shell(UnInstallConfig[I]+' 2> ./stdout');
      if SR <> 0 then begin
        Writeln(LToC[31]); //Hiba!
      end;
    end;
    Inc(I);
  until InstallConfig[I] = '';

  Writeln(LToC[32]); //Kesz!
  halt;
end;

{ *** Karakteres felhasznaloi interfeszhez szukseges eljarasok/fuggvenyek vege *** }


var
  opLng: String;
begin
  bBackup := False;
  
  PP := Dirname(FExpand(ParamStr(0))); //ProgramPath
     
  //A rendszer nyelvenek eltarolasa
  opLng := GetENV('LANG');

  //A rendszer nyelvenek megfelelo nyelvi kornyezet beolvasasa
  if opLng = 'hu_HU' then
    ReadLanguage(0)
  else
    ReadLanguage(1);
    
  if (ParamCount <> 0) then //Nyelvi parameterek vizsgalata
  begin  
    if (ParamStr(1) = '-m') or (ParamStr(1) = '--magyar') then ReadLanguage(0) else
      if (ParamStr(1) = '-e') or (ParamStr(1) = '--english') then ReadLanguage(1);
  end;

  //UnInstall parameterek vizsgalata
  if (ParamCount <> 0) and ((ParamStr(1) = '-u') or (ParamStr(1) = '--uninstall')) then
  begin
    //A rendszer nyelvenek eltarolasa
    opLng := GetENV('LANG');

    //A rendszer nyelvenek megfelelo nyelvi kornyezet beolvasasa
    if opLng = 'hu_HU' then
      ReadLanguage(0)
    else
      ReadLanguage(1);

    UnInstall;
  end;
   
  { Karakteres feluletu telepito }
  if ((ParamStr(1) = '-c') or (ParamStr(1) = '--console')) then
  begin 
    Clrscr;
    Writeln(LToC[1]+#10); //GPRS Easy Connect Telepito

    ReadConfig; //Install.conf feldolgozasa

    if getuid <> 0 then //ROOT jog ellenorzese
    begin
      Writeln(LToC[25]); //A program telepitesehez ROOT jogok szuksegesek!
      halt;
    end;

    if SR_GPRS_EC then //Futo GPRS EC keresese
    begin
      Writeln(LToC[24]); //Ugy tunik fut a GPRS Easy Connect. A telepiteshez zard be.
      halt;
    end;

    CheckDependencies; //Fuggosegek ellenorzese

    //Korabbi verzio keresese
    Write(#10+LToC[26]); //Korabbi verzio keresese...
    Shell('find /usr/bin /usr/local/bin -name "gprsec" -maxdepth 1 > ./stdout');

    if SearchInStdOut('gprsec') then
    begin
      Write(#10+LToC[28]); //Biztonsagi mentes keszitese...
      Backup; //Biztonsagi mentes
      Writeln(LToC[32]+#10); //Kesz!
      bBackup := True;
    end else
      Writeln(LToC[27]+#10); //[Nincs]

    //Licensz
    Writeln(LToC[37]); //A GPRS EC szabad szoftver; terjesztese es modositasa a GNU GPL felteteleinek megfeleloen tortenhet.
    Writeln(LToC[38]); //Tovabbi informacio a COPYING fajlban vagy a http://www.gnu.org/ oldalon.
    Writeln(#10+LToC[39]+#10); //Elfogadod a GNU GPL felteteleit? (Y/N)

    if ReadKey in ['Y', 'y'] then
    begin
      Writeln(LToC[29]); //Fajlok masolasa...
      Install;
      Writeln;
    end else
    begin
      if bBackup then
      begin
        Write(#10+LToC[30]); //Korabbi verzio visszaallitasa...
        Restore;
        Writeln(LToC[32]+#10); //Kesz!
      end;
    end;

    if bBackup then
      Write(LToC[33]) //Biztonsagi mentes eltavolitasa...
    else
      Write(LToC[34]); //Tisztogatas...

    CleanUp; //Tisztogatas
    Writeln(LToC[32]+#10); //Kesz!
  end
  else
  begin
    ReadConfig; //Install.conf feldolgozasa
    GUI; //Grafikus telepito  
  end;
end.
