/*
    WebCBQ v0.2
    Copyright (C) 2005 Nahuel Alejandro Ramos <nahuel@freesolutions.com.ar>

    description: web based cbq.init manager

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program; if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    To get the latest version, check on SourceForge.net:

		http://webcbq.sourceforge.net/
*/

function BYID(objeto) {	return document.getElementById(objeto); };

function HIDE(objeto) {	document.getElementById(objeto).style.display='none'; };

function SHOW(objeto) {	document.getElementById(objeto).style.display='block'; };

function armarParents() {
	var archivoAux = "";
	archivoAux += "DEVICE=" + BYID('C_DEVICE').value + "\n";
	archivoAux += "RATE=" + BYID('C_RATE').value + BYID('C_RBIT').options[BYID('C_RBIT').selectedIndex].value + "\n";
	archivoAux += "WEIGHT=" + BYID('C_WEIGHT').value + BYID('C_WBIT').options[BYID('C_WBIT').selectedIndex].value + "\n";
	archivoAux += "PRIO=" + BYID('C_PRIO').value + "\n";
	archivoAux += "LEAF=" + BYID('C_LEAF').value + "\n";
	if (BYID('C_BOUNDED').checked) archivoAux += "BOUNDED=yes\n"; else archivoAux += "BOUNDED=no\n";
	if (BYID('C_ISOLATED').checked) archivoAux += "ISOLATED=yes\n"; else archivoAux += "ISOLATED=no\n";
	document.forms['actualizar'].c_archivo.value = archivoAux;
};

function armarChildren() {
		var DeviceParent = new Array();
		DeviceParent = BYID('C_DEVICE').options[BYID('C_DEVICE').selectedIndex].value.split('/');
		var archivoAux = "";
		archivoAux += "DEVICE=" + DeviceParent[0] + "\n";
		archivoAux += "RATE=" + BYID('C_RATE').value + BYID('C_RBIT').options[BYID('C_RBIT').selectedIndex].value + "\n";
		archivoAux += "WEIGHT=" + BYID('C_WEIGHT').value + BYID('C_WBIT').options[BYID('C_WBIT').selectedIndex].value + "\n";
		archivoAux += "PRIO=" + BYID('C_PRIO').value + "\n";
		archivoAux += "PARENT=" + DeviceParent[1] + "\n";
		if (BYID('C_BOUNDED').checked) archivoAux += "BOUNDED=yes\n"; else archivoAux += "BOUNDED=no\n";
		if (BYID('C_ISOLATED').checked) archivoAux += "ISOLATED=yes\n"; else archivoAux += "ISOLATED=no\n";
		for (var i=0; i<BYID('C_RULES').options.length; i++) archivoAux += "RULE=" + BYID('C_RULES').options[i].value + "\n";
		document.forms['actualizar'].c_archivo.value = archivoAux;
};


function armarRegla() {
	S_ip = BYID('sourceip').value;
	S_mask = BYID('sourcemask').value;
	S_port = BYID('sourceport').value;

	D_ip = BYID('destip').value;
	D_mask = BYID('destmask').value;
	D_port = BYID('destport').value;

	var reglaAux = "";
	if (S_ip!='') {
		reglaAux += S_ip;
		if (S_mask!='') { reglaAux += '/' + S_mask };
	};
	if (S_port!='') { reglaAux += ':' + S_port };

	if (!(BYID('OigualD').checked)) {
		reglaAux += ',';
		if (D_ip!='') {
			reglaAux += D_ip;
			if (D_mask!='') { reglaAux += '/' + D_mask };
		};
		if (D_port!='') { reglaAux += ':' + D_port };
	};

	BYID('C_RULE').value = reglaAux;
};

function mostrarArchivo() {
	HIDE('mostrarC');
	SHOW('c_archivo');
	SHOW('ocultarC');
};

function ocultarArchivo() {
	HIDE('c_archivo');
	HIDE('ocultarC');
	SHOW('mostrarC');
};

