<?php
/*
    WebCBQ v0.2
    Copyright (C) 2005 Nahuel Alejandro Ramos <nahuel@freesolutions.com.ar>

    description: web based cbq.init manager

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program; if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    To get the latest version, check on SourceForge.net:

		http://webcbq.sourceforge.net/
*/
?>

<?php

require("config.php");

$ARR=file("lang/" . strtolower($language) . ".txt");
$LANG = array();
foreach($ARR as $val) {
	$LANG[language] = strtolower($language);
	$val=chop($val);
	if (ereg('^[[=space=]]*#',$val) || ereg('^[[=space=]]*$',$val))
		continue;
	list($key,$v)=split("=[[=space=]]*",$val,2);
	if (preg_match("/%\{(.+)\}/",$v,$matches)){
		$val=$LANG[$matches[1]];
		$v=preg_replace("/%\{$matches[1]\}/",$val,$v);
	}
	else $LANG["$key"]="$v";
};

function buscarIdLibre () {
	$dir = opendir($GLOBALS["cbqdir"]);  
	$cbq_ids = array();
	while($file = readdir($dir))
	{  
		$cbq_ids[] = intval(substr($file,4,4));
	}
	closedir($dir); 

	for ($i=1;$i<9999;$i++) {
		if (!in_array($i, $cbq_ids, FALSE)) {
			return $i;
		};
	};
	return 0;
}

function listPoliticas() {

	$dir = opendir($GLOBALS["cbqdir"]);  
	$cbq_files = array();
	$cbq_files[children] = array();
	$cbq_files[parents] = array();
	while($file = readdir($dir))
	{  
		if (substr($file,0,3) == "cbq")
			if (substr($file,9,3) == "P__")
				$cbq_files[parents][substr($file,4,4)] = substr($file,12,strlen($file)-9);
			else
				$cbq_files[children][substr($file,4,4)] = substr($file,9,strlen($file)-9);

	}
	closedir($dir); 
	return $cbq_files;
};

function getInfo($idRegla) {
	$dir = opendir($GLOBALS["cbqdir"]);  
	$cbq_files = array();
	while($file = readdir($dir))
	{  
		if (substr($file,0,3) == "cbq")
			if (intval(substr($file,4,4)) == $idRegla) {
				$cbq_regla[N_ARCHIVO] = $file;
				$cbq_regla[NOMBRE] = substr($file,9,strlen($file)-9);
				$cbq_regla[ARCHIVO] = "";
				$cbq_regla[RULE] = array();
				$ARR=file($GLOBALS[cbqdir] . "$file");
				foreach($ARR as $val) {
					$cbq_regla[ARCHIVO] .= $val;
					$val=chop($val);
					if (ereg('^[[=space=]]*#',$val) || ereg('^[[=space=]]*$',$val))
						continue;
					list($key,$v)=split("=[[=space=]]*",$val,2);
					if (preg_match("/%\{(.+)\}/",$v,$matches)){
						$val=$cbq_regla[$matches[1]];
						$v=preg_replace("/%\{$matches[1]\}/",$val,$v);
					}
					else {
						if ($key=="RULE") $cbq_regla[RULE][]="$v";
						else $cbq_regla["$key"]="$v";
//						echo "$key => " . "$v";
						
					};
				};
			}
	};

	closedir($dir); 
	return $cbq_regla;

};

function nuevoArchivo($hijoDe) {
  if (!($idNuevo = str_pad(strval(buscarIdLibre()), 4, "0", STR_PAD_LEFT))) {
			 return ucfirst($GLOBALS['LANG'][err_id]);
			 exit;
	};

	$getParent = getInfo(intval($hijoDe));
	
	$contenido = "DEVICE=$getParent[DEVICE]" . "\n";
	$contenido .= "RATE=50Kbit" . "\n";
	$contenido .= "WEIGHT=5Kbit" . "\n";
	$contenido .= "PRIO=5" . "\n";
	$contenido .= "PARENT=$hijoDe" . "\n";
	$contenido .= "BOUNDED=yes" . "\n";
	$contenido .= "ISOLATED=no" . "\n";

	$filename = $GLOBALS[cbqdir] . "cbq-" . $idNuevo . ".Nuevo" . $idNuevo;

	if (!$handle = fopen($filename, 'w')) {
			 return ucfirst($GLOBALS['LANG'][err_add]) . "($filename)";
			 exit;
	}
	
	if (!fwrite($handle, $contenido)) {
			return ucfirst($GLOBALS['LANG'][err_write]) . "($filename)";
			exit;
	} else {
			return ucfirst($GLOBALS['LANG'][ok_add]) . "(Nuevo$idNuevo)";
			exit;
	};
	
	fclose($handle);
};

function nuevoPadre($enNIC) {
  if (!($idNuevo = str_pad(strval(buscarIdLibre()), 4, "0", STR_PAD_LEFT))) {
			 return ucfirst($GLOBALS['LANG'][err_id]);
			 exit;
	};

	$contenido = "DEVICE=$enNIC" . "\n";
	$contenido .= "RATE=1Mbit" . "\n";
	$contenido .= "WEIGHT=0.1Mbit" . "\n";
	$contenido .= "PRIO=8" . "\n";
	$contenido .= "LEAF=none" . "\n";
	$contenido .= "BOUNDED=no" . "\n";
	$contenido .= "ISOLATED=no" . "\n";

	$filename = $GLOBALS[cbqdir] . "cbq-" . $idNuevo . ".P__Nuevo" . $idNuevo;

	if (!$handle = fopen($filename, 'w')) {
			 return ucfirst($GLOBALS['LANG'][err_add]) . "($filename)";
			 exit;
	}
	
	if (!fwrite($handle, $contenido)) {
			return ucfirst($GLOBALS['LANG'][err_write]) . "($filename)";
			exit;
	} else {
			return ucfirst($GLOBALS['LANG'][ok_add]) . "(Nuevo$idNuevo)";
			exit;
	};
	
	fclose($handle);
};



function guardarArchivo($n_archivo, $contenido) {
	$filename = $GLOBALS[cbqdir] . $n_archivo;
	if (!$handle = fopen($filename, 'w')) {
			 return ucfirst($GLOBALS['LANG'][err_read]) . "($filename)";
			 exit;
	}
	if (!fwrite($handle, $contenido)) {
			return ucfirst($GLOBALS['LANG'][err_write]) . "($filename)";
			exit;
	} else {
			return ucfirst($GLOBALS['LANG'][ok_modify]);
			exit;
	};
	
	fclose($handle);
};

function borrarArchivo($n_archivo) {
	$filename = $GLOBALS[cbqdir] . $n_archivo;
	if (!unlink($filename)) {
			 return ucfirst($GLOBALS['LANG'][err_delete]) . "($filename)";
			 exit;
	} else {
			 return "(" . substr($n_archivo,9,strlen($n_archivo)-9) . ") " . $GLOBALS['LANG'][ok_delete];
	};
	
};

function cambiarNombre($n_archivo, $cambiarA) {
	$filename = $GLOBALS[cbqdir] . $n_archivo;
	$filenameA = $GLOBALS[cbqdir] . $cambiarA;
	
	if (!copy($filename, $filenameA)) {
		 return ucfirst($GLOBALS['LANG'][err_rename]) . "($filename)";
		 exit;
	} else {
			if (!unlink($filename)) {
			 return ucfirst($GLOBALS['LANG'][ok_delete]) . "($cambiarA)" . $GLOBALS['LANG'][err_rename_delete] . "($filename)";
			 exit;
			};
			return ucfirst($GLOBALS['LANG'][ok_rename]) . "($cambiarA)";
			exit;
	};
	
	
};

function cbqinit($action) {
		
		if ($action=="START") {
			$last_line = system("sudo ". $GLOBALS['cbqinit'] . " start", $cbqOutput);
		}
		elseif ($action=="STOP") {
			$last_line = system("sudo " . $GLOBALS['cbqinit'] . " stop", $cbqOutput);
		}
		elseif ($action=="RESTART") {
			$last_line = system("sudo " . $GLOBALS['cbqinit'] . " restart", $cbqOutput);
		}
		elseif ($action=="STATS") {
			$last_line = system("sudo " . $GLOBALS['cbqinit'] . " stats", $cbqOutput);
		};

/*
		if ($last_line) {
			return $cbqOutput;
		} else {
			return strtoupper($GLOBALS['LANG'][execute_error]);
		};
*/
		return $cbqOutput;
		
		
};

?>
