# Make these real packages and do package require

proc debug {args} {
#    puts $args
}
catch {inittk}

namespace eval ::helper:: {}

proc ::helper::fileNativename { filename } {
    global tcl_platform
    if {$tcl_platform(platform) == "windows"} {
	return [file join [pwd] $filename]
    } else {
	return [file nativename $filename]
    }
}



if [catch {package require Tk}] {
    puts "\nError: Graphical mode not available"
    puts "You need graphical mode available to run Comanche"
    puts "Check the value of the DISPLAY environment variable."
    puts ""
    if ![info exists env(DISPLAY)] {
	puts "No DISPLAY environment variable found"
	puts ""
	puts "To set the DISPLAY variable, run the following:"
	puts "DISPLAY=hostname:displaynumber.screennumber"
	puts ""
	puts "For example: DISPLAY=machine_name:0.0; export DISPLAY"
	puts ""
    } else {                             
	puts "Current DISPLAY value is \"$env(DISPLAY)\""
	puts "Check that the above display is valid and you can connect to it."
	puts "Use  \"xhost +hostname\" to allow the application to connect to y\our display."
	puts "You probably want to do this before issuing a \"su\" command."
    }
    exit
}

source comanche.tcl
source ../http/http.tcl
wm title . "Comanche $::comanche::version"
package require Itcl
catch "namespace import itcl::*"
lappend auto_path .
lappend auto_path ..
lappend auto_path ../lib/xml
lappend auto_path ../lib/comanche
lappend auto_path ../lib/widgets
lappend auto_path ../lib/html
package require BWidget
package require xml 

#if [catch {package require dom::c}] {
    package require dom 
#}
package require mkWidgets
source ../help/apacheDocGui.tcl
source ../lib/comanche/libplugin/libgui.tcl
source ../lib/comanche/libplugin/helper.tcl
source ../lib/extra/tkgetdir.tcl
source ../lib/extra/center.tcl
source ../lib/extra/additional.tcl
source ../lib/extra/setBusy.tcl
source ../lib/html/htmlib/html_library.tcl
source ../lib/xml/xuibuilder/ddom.tcl
source ../lib/xml/xuibuilder/unique.tcl
source ../lib/xml/xuibuilder/xuiBuilder.tcl
source ../lib/xml/xuibuilder/xuiChoiceCreator.tcl
source ../lib/xml/xuibuilder/xuiStringCreator.tcl
source ../lib/xml/xuibuilder/xuiBooleanCreator.tcl
source ../lib/xml/xuibuilder/xuiListCreator.tcl
source ../lib/xml/xuibuilder/xuiStructureCreator.tcl
source ../lib/xml/xuibuilder/xuiAlternateCreator.tcl
source ../lib/xml/xuibuilder/xuiGroupCreator.tcl
source ../lib/xml/xuibuilder/xuiPropertyPageCreator.tcl
source ../lib/xml/xuibuilder/xuiPropertyPagesCreator.tcl
source ../lib/xml/xuibuilder/xuiDirDefinitionCreator.tcl
source ../lib/xml/xuibuilder/xuiLabelCreator.tcl
source ../lib/xml/xuibuilder/xuiNumberCreator.tcl
source ../lib/xml/xuibuilder/xuiIncludeCreator.tcl
source ../lib/xml/guiobjects/guiObject.tcl
source ../lib/xml/guiobjects/guiMultipleChoice.tcl
source ../lib/xml/guiobjects/guiLabeled.tcl
source ../lib/xml/guiobjects/guiChoice.tcl
source ../lib/xml/guiobjects/guiBoolean.tcl
source ../lib/xml/guiobjects/guiBooleanRadioButton.tcl
source ../lib/xml/guiobjects/guiStructure.tcl
source ../lib/xml/guiobjects/guiBuilder.tcl
source ../lib/xml/guiobjects/guiString.tcl
source ../lib/xml/guiobjects/guiStringDirectory.tcl
source ../lib/xml/guiobjects/guiStringFile.tcl
source ../lib/xml/guiobjects/guiAlternate.tcl
source ../lib/xml/guiobjects/guiList.tcl
source ../lib/xml/guiobjects/guiLabel.tcl
source ../lib/xml/guiobjects/guiPropertyPages.tcl
source ../lib/xml/guiobjects/guiPropertyPagesNotebook.tcl
source ../lib/xml/guiobjects/guiImage.tcl
source ../lib/xml/xuiobjects/xuiObject.tcl
source ../lib/xml/xuiobjects/xuiImage.tcl
source ../lib/xml/xuiobjects/xuiString.tcl
source ../lib/xml/xuiobjects/xuiChoice.tcl
source ../lib/xml/xuiobjects/xuiBoolean.tcl
source ../lib/xml/xuiobjects/xuiStructure.tcl
source ../lib/xml/xuiobjects/xuiPropertyPage.tcl
source ../lib/xml/xuiobjects/xuiAlternate.tcl
source ../lib/xml/xuiobjects/xuiList.tcl
source ../lib/xml/xuiobjects/xuiLabel.tcl
source ../lib/xml/xuiobjects/xuiNumber.tcl
source ../lib/xml/xuiobjects/xuiNode.tcl
source ../lib/comanche/namespace/tree.tcl
source ../lib/comanche/namespace/namespace.tcl
source ../lib/comanche/namespace/plugInDatabase.tcl
source ../lib/comanche/view/images.tcl
source ../lib/comanche/view/comancheTree.tcl
source ../lib/comanche/view/console.tcl
source ../lib/comanche/view/rightPane.tcl
source ../lib/comanche/view/view.tcl
source ../lib/comanche/view/propertyPagesDialog.tcl
source ../lib/comanche/view/wizardDialog.tcl
source ../lib/comanche/view/commandResult.tcl
source ../lib/comanche/libplugin/stack.tcl
source ../lib/comanche/libplugin/plugIn.tcl
source ../lib/comanche/libplugin/configuration.tcl
source ../lib/comanche/libplugin/parser.tcl
source ../lib/comanche/libplugin/ppManager.tcl            
source ../lib/comanche/libplugin/lremove.tcl
source ../lib/comanche/libplugin/splash.tcl
source ../lib/comanche/libplugin/mesg.tcl
source ../conf/comanche.conf
source ../url/html.tcl
source ../url/url.tcl
source ../serialize/xuiObj2XML.tcl

xuiBuilder ::globalXuiBuilder [list \
	boolean [booleanCreator ::#auto] \
	string [stringCreator ::#auto] \
	structure [structureCreator ::#auto] \
	alternate [alternateCreator ::#auto] \
	choice [choiceCreator ::#auto] \
	list [listCreator ::#auto] \
	group [groupCreator ::#auto] \
	propertyPage [propertyPageCreator ::#auto] \
	propertyPages [propertyPagesCreator ::#auto] \
	dirDefinition [dirDefinitionCreator ::#auto] \
	label [labelCreator ::#auto] \
	number [numberCreator ::#auto] \
	]

splash::init

splash::add "Initializing Comanche"
# Null object used for example when querying but do not want to get informed
# of updates. This is a hack, change

proc null {args} {} 

::mesg::processMesgCatalogDir ../messages

::comanche::namespaceServer ::ns

source ../plugins/manager/init.tcl
manager_init -namespace ::ns -moduledirectory ../plugins/manager
#source ../plugins/resolv/init.tcl
#resolv_init -namespace ::ns -moduledirectory ../plugins/resolv

#source ../plugins/apmanager/init.tcl
#apmanager_init -namespace ::ns -moduledirectory ../plugins/apmanager

#source ../plugins/apache/init.tcl
#apache_init -namespace ::ns -moduledirectory ../plugins/apache




guiBuilder ::globalGuiBuilder



comancheConsole ::#auto


#foreach d {dani1 dani2} {
#set doc [.main getframe].$d
#
#comancheView $d $doc.work ::globalGuiBuilder
#$doc raise

# View does already this ns registerConsole ::dani
#$d newNamespace ::ns
#}

splash::end

centerScreen .

wm protocol . WM_DELETE_WINDOW {exit}

proc configLocalhost {} {
    if ![winfo exists .v] {
	set d [toplevel .v -height 800 -width 800]
	wm protocol $d WM_DELETE_WINDOW { exit }
	wm title $d "Comanche"
	set frame [frame .v.ft]
	set label [label $frame.b -image icon-nettruss.gif]
	pack $label -side left -ipadx 10 -ipady 10 -anchor w
	set label [label $frame.l -text "Configuring [info hostname]"]
	pack $label -side left -ipadx 10 -ipady 10 -anchor w
	pack $frame -fill x -expand 0 -ipadx 10 -ipady 10 -side top
	
	set frame [frame .v.f]
	pack $frame -fill both -expand true -ipadx 10 -ipady 10 -side bottom
	
	comancheView dani $frame ::globalGuiBuilder
	# View does already this ns registerConsole ::dani
	dani newNamespace ::ns
    }  
}

