

package require BWidget


namespace eval ::comanche::help:: {
    variable directivesLocation /tmp/output

    # Listbox containing directives in search section

    variable listbox 

    variable tree
    variable currentHelpWindow {}
    
}
set currentDir [file dirname [file join [pwd] [info script]]]  
set ::comanche::help::directivesLocation [file join $currentDir data/output]

# We make args the name of the window. If it is a dialog, which has a grab, we need
# to make the help window a children of that dialog or we will not be able to use both
# (help and dialog} at the same time

proc ::comanche::help::getHelpWindow {{w {}}} {
    variable tree
    variable listBox
    variable rightPaneContent
    variable leftNoteBook
    variable currentHelpWindow

    if [winfo exists $w.comanchehelp] {
	# Its already there!
	
	return
    } else {
	destroy $currentHelpWindow
    }
    set currentHelpWindow $w.comanchehelp
    toplevel $currentHelpWindow 
    pack [label $currentHelpWindow.l -text "This online documentation is still in development and some links may not work"] -fill x  -anchor n
    set frame [frame $currentHelpWindow.frame]
    set panedWindow [PanedWindow $frame.pw -side bottom]
    set leftPaneFrame [$panedWindow add -minsize 100]
    set rightPaneFrame [$panedWindow add]
    set okButton [button $currentHelpWindow.b \
	    -text Ok -command "destroy $currentHelpWindow"]
    pack $okButton -side bottom -fill x -expand true
    # We use a comanche tree that will give us three callbacks
    # showMenu, populateNode (we ignore)
    # nodeSelectedNotidy (we use to update right pane)
    
    set leftNoteBook [NoteBook $leftPaneFrame.nb]
    set availableFrame [$leftNoteBook insert end available -text "Available" \
	    -image information]
    $leftNoteBook raise available
    
    set tree [comancheTree ::#auto $availableFrame ::comanche::help::processEvent]
    
    # This listbox will be used when being called from the outside, with several directives
    
    set listboxFrame [$leftNoteBook insert end search -text "Search" -image files] 
    set contframe $listboxFrame
    set scwin [ScrolledWindow $contframe.scwin]
    set listBox [ ListBox [$scwin getframe].listbox  -multicolumn 0 \
	    -background white -height 8 -selectbackground #00008B \
	    -selectforeground white]
    $listBox bindText <Button-1> "::comanche::help::processEvent listBoxNodeSelected"
    $listBox bindImage <Button-1> "::comanche::help::processEvent listBoxNodeSelected"
    $scwin setwidget $listBox
    pack $scwin -fill both 
    pack $listBox -fill both 
    
    # HTML. We use Comanche rightPane, we have an observer to process Signals 
    # (clicking on URLs)
    
    $leftNoteBook compute_size
    pack $leftNoteBook -expand true -fill both
    set rightPaneContent [ rightPane ::#auto $rightPaneFrame ::comanche::help::processEvent]

    pack $panedWindow -expand true -fill both
    pack $frame -expand true -fill both
    
    ::comanche::help::createDirectiveTree    

}

proc ::comanche::help::processEvent {args} {
    variable tree
    variable nodeToModuleDirectiveMapping
    variable moduleDirectiveToNodeMapping
    variable listBox
    set signal [lindex $args 0]
    switch $signal {
	nodeSelectedNotify {
	    set nodeSelected [lindex $args 1]
	    eval showDirective $nodeToModuleDirectiveMapping($nodeSelected)
	} processSignal {
	    set type [lindex $args 1]
	    switch $type {
		showHelp {
		    set module [lindex $args 2]
		    set directive [lindex $args 3]
		    $tree selectNode \
			    $moduleDirectiveToNodeMapping([list $module $directive])
		}
	    }
	} listBoxNodeSelected {
	    set selectedNode [lindex $args 1]
	    $listBox selection set $selectedNode 
	    $tree selectNode \
		    $moduleDirectiveToNodeMapping([$listBox itemcget $selectedNode -data])
	}
    }
}




proc ::comanche::help::createDirectiveTree {} {
    variable nodeToModuleDirectiveMapping
    variable moduleDirectiveToNodeMapping
    variable directivesLocation
    variable tree
    foreach module [glob [file join $directivesLocation *]] {
	set moduleName [file tail $module] 
	if [string match $moduleName CVS] {
	    continue
	}
	set moduleNode [unique::newId]
	$tree addNode root $moduleNode -type container -text $moduleName \
		-openImage information -closedImage information 
	set nodeToModuleDirectiveMapping($moduleNode) [list $moduleName {}]
	foreach directive [glob [file join $module *]] {
	    if [file isfile $directive] {
		set dirName [lindex [split [file tail $directive] . ] 0]
		set dirNode [unique::newId]
		$tree addNode $moduleNode $dirNode -type leaf -text $dirName \
			-openImage files -closedImage files
		set nodeToModuleDirectiveMapping($dirNode) [list $moduleName $dirName]
		set moduleDirectiveToNodeMapping([list $moduleName $dirName]) $dirNode
	    }
	}
    }
}

proc ::comanche::help::showDirective {module directive} {
    variable directivesLocation
    variable rightPaneContent
    if [llength $directive] {
	set htmlFile [file join $directivesLocation $module $directive.html]
	set f [ open $htmlFile]
	$rightPaneContent loadHTML [read $f]
	close $f
    } 
}

proc ::comanche::help::showDirectives {directiveList} {
    variable listBox
    variable leftNoteBook

    $listBox delete [$listBox items]
    
    # directive list: pairs of module/directive
    
    foreach dirPair $directiveList {
	set module [lindex $dirPair 0]
	if [string match $module coredirs] {set module core}
	set directive [lindex $dirPair 1]
	$listBox insert end $directive -image listicon -data [list $module $directive] \
		-text $directive
	#puts "ddd $module $directive"
    }
    $leftNoteBook raise search
    $listBox selection set [lindex [$listBox items] 0 ]
    processEvent listBoxNodeSelected [lindex [$listBox items] 0 ]  



}

