
# mime_magic and expires break :(

lappend auto_path ../xuibuilder

package require dom
source ../xuibuilder/ddom.tcl

namespace eval ::comanchehelp:: {
    set outputDir /tmp/output/
}

proc ::comanchehelp::processFile {module fileName} {
    set f [open $fileName]
    set apacheConf [dom::DOMImplementation parse [read $f]]
    close $f 
    set nodeList [dom::children [dom::rp $apacheConf html/body ]]

    while {[llength $nodeList]} {
	set current [lindex $nodeList 0]
	set nodeList [lrange $nodeList 1 end]

	# Need to put anything before Directives in module description

	# getTagName was moified so if node is text node, returns /textnode

	switch [dom::getTagName $current] {
	    h2 {
		set directiveNodeList {}
		if ![catch {set id [::dom::getAttribute [dom::rp $current a] id]} dummy] {
		    set directiveName $id

		    # Some special cases like mod_auth_anon, dll, include, mime, so, proxy

		    switch $directiveName {
			Directives - Example - CompileTimeOptions - RevisionHistory 
			- Person - Sourcecode - creating - flowctrl - multipleext - configs 
			- creating {
			    # (May be interesting to add them as pieces of information, 
			    # but making distinction clear from directives??

			} browsermatch - metafiles - metadir - metasuffix 
			    - cachenegotiateddocs - cookieexpires - cookiename 
			    - cookietracking {

			    # No <hr> to separate directives
			    
			} nedtodosomethingforcgi {

			} default {
			    set directiveDesc \
				    [lindex [::dom::getText [dom::rp $current a]] 0]
			    while {![string match [::dom::getTagName $current] hr]} {
				set current [lindex $nodeList 0]
				set nodeList [lrange $nodeList 1 end]
				lappend directiveNodeList $current
			    }
			    ::comanchehelp::processDirective \
				    $module $directiveName $directiveDesc $directiveNodeList
			}
		    }
		} else {
		    
		}
	    } {/textnode} {
	    } default {
	    }
	}
    }

}

proc ::comanchehelp::processDirective {module directiveName directiveDesc nodeList} {
    variable outputDir
    set result {}
    append result "<h2>$directiveDesc</h2><br>"
    foreach node $nodeList {
	::comanchehelp::processHtml $module $node
	append result [dom::DOMImplementation serialize $node]
    }
    catch {file mkdir [file join $outputDir $module]} dummy
    set f [open [file join $outputDir $module $directiveName.html] w]
    puts $f $result
    close $f
}

proc ::comanchehelp::processHtml {module node} {
    set result {}
    switch [dom::getTagName $node] {
	a {
	    set hrefName [::dom::getAttribute $node href]
	    if [string match "directive-dict.html#*" $hrefName] {
		::dom::setAttribute $node href "command showHelp help_definitions \
			    [lindex [split $hrefName #] 1]"
	    } elseif [string match #* $hrefName] {
		::dom::setAttribute $node href "command showHelp $module \
			[string trim $hrefName #]"
	    } elseif [string match mod*.html#* $hrefName] {
		set list [split $hrefName #]
		regexp mod_(.*)\.html [lindex $list 0] dummy module
		set directive [lindex $list 1]
		::dom::setAttribute $node href "command showHelp $module $directive"
	    } else {
		puts "Does not match [::dom::getAttribute $node href]"
	    }
	} /textnode {
	} hr {
	} default {
	    foreach child [dom::children $node] {
		::comanchehelp::processHtml $module $child
	    }
	}
    }
    return $result
}

foreach file [glob /tmp/manual/*.html] {
    puts "Processing $file"
    if [regexp mod_(.*)\.html $file dummy module] {
	::comanchehelp::processFile $module $file
    } elseif [regexp core.html $file dummy module] {
	::comanchehelp::processFile core $file
    }
}