

class dirDefinition {
    variable dirMap
    method getDirectiveByName { name }
    method getDirectivesNames {} { 
	return [array names dirMap]
    }
    method getDirectives {} { 
	foreach one [array names dirMap] {
	    lappend result $dirMap($one)
	}
	return $result
    }
    method addDirectiveDefinition { xuiDirDefinitions }
}

body  dirDefinition::addDirectiveDefinition { xuiDirDefinitions } {
    set result {}
    foreach xuiDirDef $xuiDirDefinitions {
	foreach dir [$xuiDirDef getComponents] {
	    set dirMap([string tolower [$dir getName]]) $dir
	    lappend result $dir
	}
    }
    return $result
}

body dirDefinition::getDirectiveByName { name } {
    set name [string tolower $name]
    if [info exists dirMap($name)] {
	return $dirMap($name)
    } else { 
	return {}
    }
}

class pPDefinition {
    inherit dirDefinition
    method getPPByName { name } {
        getDirectiveByName $name
    }
    method addPPDefinition {xuiDirDefinitions} {
    eval addDirectiveDefinition $xuiDirDefinitions
    }
    
}


class confDocument {
   variable containerList {}
   variable root {}
   constructor {} {
   set root [$this newContainer]
   $root setName root
   $root setClasses rootContainer
   $root setLabel "Root Container"
   }
   method getRootContainer { } {return $root}
   method addDirective { obj container }
   method addContainer { container value class}
   method getContainers { container }
   method getDirectives { container }
   method getDirectiveByName { container name}
   method clear {}
   method newContainer {}
   method removeContainer { parentContainer container }
}

body confDocument::clear {} {
    eval delete object $root $containerList
    set containerList {}
    set root [$this newContainer]
   $root setName root
   $root setClasses rootContainer
   $root setLabel "Root Container"
}
body confDocument::getContainers { container } {
    set result {}
    foreach cnt \
	    [[$container getComponentByName containerChildren] getChildren] {
	lappend result [$cnt getValue]
    }
    return $result
}


body confDocument::getDirectiveByName { container name} {
    if [catch {[$container getComponentByName directiveChildren] \
	    getComponentByName $name } component ] {
	# The component does not exist, we get an error
	return {}
    } else {
	return $component
    }
}

body confDocument::getDirectives { container } {
    return [[$container getComponentByName directiveChildren] getComponents] 
}

body confDocument::addDirective { obj container } {

   
   [$container getComponentByName directiveChildren] addComponent $obj

}

body confDocument::addContainer { container value class} {
    
   set newCont [ $this newContainer ]
   $newCont addClass $class
   $newCont setName $value
   
   lappend containerList $newCont
   set contList [$container getComponentByName containerChildren]
   set reference [$contList newChild]
   $reference setValue $newCont
   $reference setName $newCont
   $contList insertChild $reference
   return $newCont
}


body confDocument::newContainer {} {
   set cont [xuiStructure ::#auto]
   $cont setXuiClass Structure
   $cont setStyle normal
   $cont setAlign vertical
   
   set list [ xuiList ::#auto ]
   $list setName containerChildren
   set pt [xuiString ::#auto]
   $pt setXuiClass string
   $list setPrototype $pt
   
   $cont addComponent $list
   
   set st [xuiStructure ::#auto]
   $st setName directiveChildren
   $st setLabel directiveChildren
   $st setXuiClass structure
   
   $cont addComponent $st
   
   return $cont
}


body confDocument::removeContainer { parentContainer container } {
    #containerChildren is a string of xuiStrings whose values are 
    # names of xuiContainer
    set myContainerList [$parentContainer getComponentByName containerChildren]
    $myContainerList deleteChild \
            [$myContainerList getChildrenByName $container]
    lremove containerList $container
    destroy object $container
}

