
namespace eval ::libgui:: {}

proc ::libgui::createXuiFromFile {filename} {
    if ![file exists $filename] {
	error "File '$filename' does not exists while trying to create XUI"
    }
    set f [open $filename]
    set domDoc [dom::DOMImplementation	parse [read $f]]
    set doc [::globalXuiBuilder renderDocument $domDoc]
    dom::DOMImplementation destroy $domDoc
    close $f          
    return $doc
}

proc ::libgui::createXuiFromText {text} {
    set domDoc [dom::DOMImplementation	parse "<bla>$text</bla>"]
    set doc [::globalXuiBuilder renderDocument $domDoc]
    dom::DOMImplementation destroy $domDoc
    return $doc
}
