class genericParser {
    variable stack
    variable specialCaseMapping
    public variable mainConfFile {}
    variable currentContainer
    variable rootContainer
    
    # We need to know the current file we are parsing, to 
    # properly handle multiple relative includes
    # httpd.conf includes jser/jserv.conf with in turns includes kk.conf

    variable currentFile

    public variable dirDefinition
    public variable xmlConf

    constructor { dirDefinitionV xmlConfV } {
	set dirDefinition $dirDefinitionV
	set xmlConf $xmlConfV
	set stack [stack ::#auto]
    }          
    method setSpecialCase { specialCaseObject args }
    method init { {confFile {}} }
    method parseFile { file }
    method parseLine { text }
    method getDirectiveName
    method getDirectiveValue
    method getSpecialCasesForXuiDir
}



body genericParser::getSpecialCasesForXuiDir { xuiDirName } {
    set result {}
    #puts "xuiDirName $xuiDirName"
    parray specialCaseMapping
    foreach directive [array names specialCaseMapping] {
	if [string match $xuiDirName $specialCaseMapping($directive)] {
	    append result ,$directive
	}
    }
    return [string trimleft $result ,]
} 

body genericParser::setSpecialCase { procedure args } {
    foreach directive $args {
	set specialCaseMapping([string tolower $directive]) $procedure
   }
}

body genericParser::init { {confFile {}} } {
    if ![llength $confFile] {
	if ![llength $mainConfFile] {
	    error "There is not configuration file defined"
	} 
	set confFile $mainConfFile
    }
    $stack clear
    $xmlConf clear
    set rootContainer [set currentContainer [ $xmlConf getRootContainer ]]
    set currentFile $confFile
    $this parseFile $confFile
}

body genericParser::parseFile { filename } {
    set tmpFile $currentFile
    set currentFile $filename
    set f [open $filename]
    while {![eof $f]} {
	gets $f line
	parseLine $line
    }
    close $f   
    set currentFile $tmpFile
}

