
# ppManager --
# Used to load and save xuiPropertyPages values from/to a XMl configuration
# document

class ppManager {
    method loadPropertyPage { xuiPropertyPage confDoc container  }
    method savePropertyPage { xuiPropertyPage confDoc container }
    method processComponentForLoad { component confDoc container }
    method processComponentForSave { component confDoc container }
}

body ppManager::savePropertyPage { xuiPropertyPage confDoc container } {
    foreach component [$xuiPropertyPage getComponents] {
	processComponentForSave $component $confDoc $container
    }
}

body ppManager::processComponentForSave { component confDoc container } {
    switch [$component getXuiClass] {
	group {
	    foreach child [$component getComponents] {
		processComponentForSave $child $confDoc $container
	    }
	}
	default {   
	    set componentName [$component getName]
	    if [llength [set directive [$confDoc getDirectiveByName \
		    $container $componentName ]]] {
		$component copyClone $directive
	    } else {
	        set new [$component clone]
		$confDoc addDirective $new $container
	    }
	}
    }
}

body ppManager::loadPropertyPage { xuiPropertyPage confDoc container } {
    foreach component [$xuiPropertyPage getComponents] {
	processComponentForLoad $component $confDoc $container
    }
}

body ppManager::processComponentForLoad { component confDoc container } {
    switch [$component getXuiClass] {
	group {
	    foreach child [$component getComponents] {
		processComponentForLoad $child $confDoc $container
	    }
	}
	default {   
	    set componentName [$component getName]
	    if [llength [set directive [$confDoc getDirectiveByName \
		    $container $componentName ]]] {
		$directive copyClone $component
	    } else {
		$component reset
	    }
	}
    }
}




