
# commandResult --
#    When a command is excuted in the server, this class is in charge of
# displaying the results

class commandResult {
    variable guiRenderer
    variable dialog
    variable guiPP {}
    variable f
    constructor { gr } {
        set guiRenderer $gr
	set w .[unique::newId]
	set dialog [Dialog $w \
	        -parent . \
		-title {Result}\
		-modal local]
	set f [frame [ $dialog getframe ].f ]
	pack $f  -fill both -expand true -padx 2 -pady 2
	$dialog add -text Ok
	#$dialog add -text Cancel
	pack propagate $dialog 1
	wm protocol $w WM_DELETE_WINDOW { ; }
    }
    method show { xuiData }
    method _clear {}
}

body commandResult::show  { xuiData } {
    $this _clear
    if ![string length [$xuiData getComponents]] {
	::comanche::showMessage "Command returned no data"
	return CANCEL
    }   
    if [string length [set icon [[$xuiData getComponents] cget -icon ]]] {
	pack [label $f.label -image $icon] -side left 
    }
    set guiPP [$guiRenderer render $f [$xuiData getComponents] ]
    switch  [$dialog draw] {
	-1 { 
	    error {This should never occur. Dialog only to be dismissed using
	    Ok or Cancel}
	} 0 {
	    return OK
	} 1 {
	    return CANCEL
	}
	default { 
	    error {This should never occur. But you know, sometimes \
		    impossible things happen}
	}
    }
}

body commandResult::_clear {} {
    if [llength $guiPP] {
        delete object $guiPP
        destroy $f.label
	set guiPP {}
    }
}
