# comancheConsole --
#
# This is the main Comanche window backbone, it controls different views and
# namespaces to control different machines at once.


proc arrangeDocs { sHow }  {
    global doc
    catch { $doc Arrange $sHow } kk
}

class comancheConsole {
    
    constructor {} {
	set descmenu {
            "&Comanche" all file 0 {
		{command "E&xit" {} "Exit Comanche" {} -command exit}
            }
            "&Help" all help 0 {
                {
		    command "&Help" {} "Help" {} -command {
                        global tcl_platform
                        if {$tcl_platform(platform) == "windows"} {
                            exec explorer http://www.comanche.org &
			} else {
                            exec netscape http://www.comanche.org &
			}
		    }
		}
		{command "&About" {} "About Comanche" {} -command {                MessageDlg .d -message "Comanche $::comanche::version \n\
			\n\
                        http://www.comanche.org\n\n\
                        Sponsored by Covalent Technologies\n\
                        \n\
                        Brought to you by The Comanche Team:\n\
                        Carmen Carmack, Craig Khotz, Daniel Lopez,\n\
                        Ryan Morgan, Adam Qualset \n\n\
                        Many thanks to :\n\
                        Lars Dittman, COM Center http://www.com.dtu.dk\n\
                        Jorge Chavez, ESI http://www.esi.us.es\n" -type ok
		   }
	       }
	   }
       }
       set shell [MainFrame .main \
	       -textvariable global_help -separator both  -menu $descmenu -width 800 -height 300]
       $shell addindicator -textvariable global_help
       set b [ibutton [$shell getframe].localhost \
	       -text {Comanche} \
	       -image icon-nettruss.gif \
	       -command configLocalhost]
       pack $b -fill both -padx 20 -pady 20
       
       foreach {image name path} [helper::readFile ../conf/external.conf] {
	   set id [unique::newId]
	   set b [ibutton [$shell getframe].$id \
		   -text $name \
		   -image $image \
		   -command "comanche::execProgram $path"]
	   pack $b -fill both -padx 20 -pady 20
       }
       pack $shell -fill both -expand true
   }
   
}

proc comanche::execProgram {path} {
    exec $path &  
    after 9000
}