

class propertyPagesDialog {
    variable pPageXui
    variable guiRenderer
    variable dialog
    variable guiPP {}
    variable w
    variable f
    variable helpModuleDirectivePairs
    constructor { gr } {
        set guiRenderer $gr
	set w .[unique::newId]
	set dialog [Dialog $w \
	        -parent . \
		-title {Properties configuration}\
		-modal local]
	set f [frame [ $dialog getframe ].f ]
	pack $f  -fill both -expand true -padx 2 -pady 2
	$dialog add -text Ok
	$dialog add -text Cancel
	$dialog add -text Help -command [code $this showHelp]
	pack propagate $dialog 1
	wm protocol $w WM_DELETE_WINDOW { ; }
    }
    method show { xuiData }
    method _clear {}
    method lookForHelp { component } 
    method showHelp {} {
	set xuiPP [$guiPP getSelectedPropertyPageXui]
	set helpModuleDirectivePairs {} 
	foreach component [$xuiPP getComponents] { 
	    lookForHelp $component 
	} 
	if [llength $helpModuleDirectivePairs] {
	    ::comanche::help::getHelpWindow $w
	    ::comanche::help::showDirectives $helpModuleDirectivePairs 
	}
    }
}

body ::propertyPagesDialog::lookForHelp { component } {
    set helpPointer [$component cget -helpReference]
    if [llength $helpPointer] {
	set dummy [split $helpPointer =]
	set module [lindex $dummy 0]
	foreach one [split [lindex $dummy 1] ,] {
	    lappend helpModuleDirectivePairs [list $module $one]
	}
	return
    }
    switch [$component getXuiClass] {
	structure - group {
	    foreach comp [$component getComponents] {
		lookForHelp $comp
	   }   
       } default {
       }
    }
}

body propertyPagesDialog::show  { xuiData } {
    $this _clear
    if ![string length [$xuiData getComponents]] {
	::comanche::showMessage "This node has no properties"
	return CANCEL
    }
    set guiPP [$guiRenderer render $f $xuiData]
    switch  [$dialog draw] {
	-1 { 
	    error {This should never occur. Dialog only to be dismissed using
	    Ok or Cancel}
	} 0 {
	    return OK
	} 1 {
	    return CANCEL
	}
	default { 
	    error {This should never occur}
	}
    }
}

body propertyPagesDialog::_clear {} {
    if [llength $guiPP] {
        delete object $guiPP
	set guiPP {}
    }
}

