
class rightPane {
    variable observer
    variable htmlWidget
    constructor { frame observerView } {
        global HTML_RightPane
	set observer $observerView
	set scwindow [ScrolledWindow $frame.scwindow]
	set htmlWidget [html [$scwindow getframe].htmlWidget -bg white \
		-imagecommand "$this htmlImage" \
		 -underlinehyperlinks 1]
	pack $htmlWidget -fill both -expand true
	$scwindow setwidget $htmlWidget
	pack $scwindow -fill both -expand true  
	bind $htmlWidget.x <1> [list $this hrefBinding %x %y]
	bind HtmlClip <Motion> {
	    set parent [winfo parent %W]
	    set url [$parent href %x %y]
	    if {[string length $url] > 0} {
		$parent configure -cursor hand2
	    } else {
		$parent configure -cursor {}
	    }                                     
	}
    }
    method loadHTML
    method processHref
    method htmlImage
    method hrefBinding
}

body rightPane::processHref { href } {
    $observer processURL $href
}

body rightPane::loadHTML { html } {
    $htmlWidget clear
    $htmlWidget parse $html
}

body rightPane::htmlImage {src args} {
    return $src
}

body rightPane::hrefBinding {x y} {
    processHref [$htmlWidget href $x $y]
}

