

class comanche::wizardDialog {
    variable guiRenderer
    variable dialog
    variable guiPP {}
    variable f

    constructor { gr } {
        set guiRenderer $gr
	set w .[unique::newId]
	set dialog [Dialog $w \
	        -parent . \
		-title {}\
		-modal local]
	set f [frame [ $dialog getframe ].f ]
	pack $f  -fill both -expand true -padx 2 -pady 2
	$dialog add -text Prev
	$dialog add -text Next
	$dialog add -text Cancel
	pack propagate $dialog 1
	wm protocol $w WM_DELETE_WINDOW { ; }
    }
    method show {selectedPageName pageList }
    method showPage {page}
    method _clear {}
}

body comanche::wizardDialog::show {selectedPageName pageList} {
    if ![llength $pageList] {
	::comanche::showMessage "No wizard available for this node"
	return CANCEL
    }
    if ![string length $selectedPageName] {
	error "Must select a page"
    } else {
	set selectedPage [plugInUtils::getPageByName $selectedPageName $pageList]
    }
    showPage $selectedPage
}

body comanche::wizardDialog::showPage  { page } {
    $this _clear
    if [string length [set icon [$page cget -icon ]]] {
	pack [label $f.label -image $icon] -side left 
    }
    $dialog configure -title [$page getLabel]
    foreach {index pageClass} {0 startPage 2 endPage} {
	if [$page doYouBelongTo $pageClass] {
	    $dialog itemconfigure $index -state disabled
	    switch $pageClass {
		endPage {
		    $dialog itemconfigure 0 -state disabled
		    $dialog itemconfigure 1 -text Finish
		}
	    }
	}
    }
    set guiPP [$guiRenderer render $f $page ]
    switch  [$dialog draw] {
	-1 { error {This should never occur. Dialog only to be dismissed using
	Ok or Cancel}
    } 0 {
	return PREV
    } 1 {
	return NEXT
    } 2 {
	return CANCEL
    }
	default { error {This should never occur}}
    }
    
}

body comanche::wizardDialog::_clear {} {
    $dialog itemconfigure 0 -state normal -text Prev
    $dialog itemconfigure 1 -state normal -text Next   
    $dialog itemconfigure 2 -state normal -text Cancel
    if [llength $guiPP] {
        delete object $guiPP
        destroy $f.label
	set guiPP {}
    }
}

