# From a deja.com article
#  withBusyCursor { cmds ... }
#                                                                     
# Changes the cursor of every window in the application               
# to a watch, evaluates 'cmds', then restores the cursor.
#
# Returns: Whatever 'cmds' does.
#
#  Source: busy.tcl, Revision: 1.7
#

proc withBusyCursor {cmd} {
    global errorInfo errorCode
    set busy {}
    set list {.}
    while {$list != ""} {
	set next {}
	foreach w $list {
	    catch {set cursor [$w cget -cursor]}
	    if {[winfo toplevel $w] == $w || $cursor != ""} {
		lappend busy $w $cursor
		set cursor {}
	    }
	    set next [concat $next [winfo children $w]]
	}
	set list $next
    }
    
    foreach {w _} $busy {
	catch {$w configure -cursor watch}
    }
    
    update idletasks
    
    set rc [catch {uplevel 1 $cmd} result]
    set ei $errorInfo
    set ec $errorCode
    
    foreach {w cursor} $busy {
	catch {$w configure -cursor $cursor}
    }
    
    return -code $rc -errorinfo $ei -errorcode $ec $result
}

