

class guiAlternate {
    inherit guiObject
    variable selectedRadioButton 0
    variable buttonMapGui
    variable buttonMapXui
    variable radiobuttons
    variable containerFrames
    constructor { frame xuiObject guiBuilder} {
	set subject $xuiObject
	set i 0
	set surrFrame $frame	
	if ![string compare [$subject getStyle] normal] {
	    set bframe [TitleFrame $frame.tf -relief groove \
		    -text [$subject getLabel]]
	    set surrFrame [$bframe getframe]
	    pack $bframe -fill both -expand true
	}
        set labeled {}
	set maxLabelSize 0
	foreach alternateItem [$subject getComponents] {
	    set newFrame [frame $surrFrame.$i]
	    lappend containerFrames $newFrame
	    set rb [radiobutton $newFrame.rb \
		    -variable [scope selectedRadioButton ] \
		    -value $i] 
	    pack $rb -side left
	    lappend radiobuttons $rb
	    set guiFrame [frame $newFrame.gui]
	    set gui [$guiBuilder render $guiFrame $alternateItem]
	    set buttonMapGui($i) $gui
	    set buttonMapXui($i) $alternateItem
	    if [ $gui isa guiLabeled ] {
		lappend labeled $gui
		if [expr [$gui getLabelLength] > $maxLabelSize] {
		    set maxLabelSize [$gui getLabelLength] 
		}
	    }
	    incr i
	    pack $guiFrame -side left
	    pack $newFrame -anchor w
	}
	if [expr $maxLabelSize > 40] {
	    set maxLabelSize 40
        }  
	foreach element $labeled {
	    $element setLabelLength $maxLabelSize
	}
	if [llength [set tmp [$subject getSelectedComponent]]] {
	    set pos [lsearch -exact [array get buttonMapXui] $tmp]
	    set selectedRadioButton [lindex [array get buttonMapXui]\
		    [expr ($pos - 1 )]]
	}  
	selectGui
	trace variable [scope selectedRadioButton] w [code $this valueChanged]
	sync
    }
    destructor {
	foreach {name ui} [array get buttonMapGui]  {
	    delete object $ui
	}
	eval destroy $containerFrames
    }
    method selectGui { }
    method sync {}
    method valueChanged { args }
    method disableAll {}
    method enable {}
    method disable {}
    method queryState {}
}

body guiAlternate::selectGui { } {
    disableAll
    $buttonMapGui($selectedRadioButton) enable
}

body guiAlternate::disableAll {} {
    foreach element [array names buttonMapGui] {
	$buttonMapGui($element) disable
    }
}

body guiAlternate::sync {} {
    $subject selectComponent $buttonMapXui($selectedRadioButton)
}

body guiAlternate::valueChanged {args} {
    selectGui
    sync
}

body guiAlternate::enable {} {
    set state 1
    foreach rb $radiobuttons {
	$rb configure -state normal
    }
    selectGui
}

body guiAlternate::disable {} {
    set state 0
    disableAll
    foreach rb $radiobuttons {
	$rb configure -state disabled
    }
}

body guiAlternate::queryState {} {
    return $state
}
