

class guiBoolean {
    inherit guiObject
    variable checkBox
    variable value 
    variable state
    constructor {frame xuiObject} {
	set subject $xuiObject
	set checkBox [checkbutton $frame.c]
	$checkBox configure -text [$subject getLabel] -variable [scope value]
	if ![string compare [set value [$subject getValue]] {}] {
	    if ![string compare \
		    [set value [set default [$subject getDefault]]] {} ] {
		set value 0
	    }
	}
	trace variable [scope value] w [code $this valueChanged]        
	pack $checkBox -side left
	sync
    }
    method enable {}
    method disable {}
    method queryState {}
    method sync {}
    method valueChanged {args}
}

body guiBoolean::sync {} {
    if $value {
	$subject setValue
    } else {
	$subject clearValue
    }
}

body guiBoolean::valueChanged {args} {
    sync
}

body guiBoolean::enable {} {
    set state 1
    $checkBox configure -state normal
}

body guiBoolean::disable {} {
    set state 0
    $checkBox configure -state disabled
}

body guiBoolean::queryState {} {
    return $state
}


