

class guiBooleanRadioButton {
    inherit guiObject
    variable checkBox
    variable value 
    variable state
    constructor {frame xuiObject} {
	set subject $xuiObject
	set bframe [frame $frame.f]
	
	# In the future change this to be defined by style (Yes/No On/Off)

	set i 1
	pack [label $bframe.l -text [$subject getLabel]] -side left 
	foreach one { Yes No } {
	    set rb [radiobutton $bframe.$i \
		    -variable [scope value] \
		    -value $i -text $one]   
            pack $rb -anchor w
	    incr i -1
	}
	if ![string compare [set value [$subject getValue]] {}] {
	    if ![string compare \
		    [set value [set default [$subject getDefault]]] {} ] {
		set value 0
	    }
	}
	trace variable [scope value] w [code $this valueChanged]  
	pack $bframe -side left
	sync
    }
    method enable {}
    method disable {}
    method queryState {}
    method sync {}
    method valueChanged {args}
}

body guiBooleanRadioButton::sync {} {
    if $value {
	$subject setValue
    } else {
	$subject clearValue
    }
}

body guiBooleanRadioButton::valueChanged {args} {
    sync
}

body guiBooleanRadioButton::enable {} {
    set state 1
    $checkBox configure -state normal
}

body guiBooleanRadioButton::disable {} {
    set state 0
    $checkBox configure -state disabled
}

body guiBooleanRadioButton::queryState {} {
    return $state
}


