
class guiBuilder {
    method render {frame xuiObject} 
}

body guiBuilder::render { frame xuiObject } {
    switch  [$xuiObject getXuiClass]  {
	boolean {
	    if [$xuiObject doYouBelongTo radioYesNo] {
		return [ guiBooleanRadioButton ::#auto $frame $xuiObject ]
	    } else {
		return [ guiBoolean ::#auto $frame $xuiObject ]
	    }
	} choice {
	    if [$xuiObject doYouBelongTo multipleChoice] {
	       return [ guiMultipleChoice ::#auto $frame $xuiObject ]
	    } else {
	    return [ guiChoice ::#auto $frame $xuiObject ]
	    }
	} string {
	    if [$xuiObject doYouBelongTo directory] {
	    return [ guiStringDirectory ::#auto $frame $xuiObject] 
	    } elseif [$xuiObject doYouBelongTo file] {
	    return [ guiStringFile ::#auto $frame $xuiObject]
	    } else {
	    return [ guiString ::#auto $frame $xuiObject]
	    }
	} number {
	    return [ guiString ::#auto $frame $xuiObject]
	} label {
	    return [ guiLabel ::#auto $frame $xuiObject]
	} structure {
	    return [ guiStructure ::#auto $frame $xuiObject $this]
	} alternate {
	    return [ guiAlternate ::#auto $frame $xuiObject $this]
	} image {
	    return [ guiImage ::#auto $frame $xuiObject ]
	} list {
	    return [ guiList ::#auto $frame $xuiObject $this]
	} group {
	    return [ guiStructure ::#auto $frame $xuiObject $this]
	} propertyPage {
	    return [ guiStructure ::#auto $frame $xuiObject $this]

	} propertyPages {
     	   if {[llength [$xuiObject getComponents]] > 6} {
	    return [ guiPropertyPages ::#auto $frame $xuiObject $this]
	 } else {
	    return [guiPropertyPagesNotebook ::#auto $frame $xuiObject $this]
	 }
	} default {
	    error "Type [$xuiObject getXuiClass] not recognized"
	}
    }
}




