

class guiChoice {
    inherit guiObject guiLabeled
    variable comboBox 
    variable nameMap 
    variable selectedIndex {}

    constructor {frame xuiObject} {
	array set nameMap {}
	set subject $xuiObject
	set comboBox [ComboBox $frame.[unique::newId] ]
	$comboBox configure -label [$subject getLabel] -editable 0
	set i 0
	set tmp {}
	set selection [$subject getSelected]
	if ![llength $selection] {
	    set selection [$subject getDefault]
	}
	if ![llength $selection] { set selection __ }
	set maxEntryLength 0
	foreach {name text} [$subject getChoices] {
	    set nameMap($i) $name
	    if ![string compare $name $selection] {
		set selectedIndex $i
	    }
	    if [expr [string length $text ] > $maxEntryLength ] {
	        set maxEntryLength [string length $text]
	    }
	    lappend tmp $text
	    incr i
	}
	$comboBox configure -values $tmp -modifycmd [code $this valueChanged] \
		-height  $i -width $maxEntryLength
	pack $comboBox -side left
	if [string compare $selectedIndex {} ] {
	    $comboBox setvalue @$selectedIndex
	    valueChanged
	} else {
	    $comboBox setvalue @0
	    valueChanged
	}
	sync
    }
    destructor {
	destroy $comboBox
    }
    method sync {}
    method valueChanged {}
    method enable {}
    method disable {}
    method queryState {}
    method getLabelLength {} { return [string length [$subject getLabel]] }
    method setLabelLength { length } \
	    { $comboBox configure -labelwidth $length }
}

body guiChoice::sync {} {
    $subject selectItem $nameMap($selectedIndex)
}

body guiChoice::valueChanged {} {
    set selectedIndex [ $comboBox getvalue ]
    $this sync
}

body guiChoice::enable {} {
    set state 1
    $comboBox configure -state normal
}

body guiChoice::disable {} {
    set state 0
    $comboBox configure -state disabled
}

body guiChoice::queryState {} {
    return $state
}



