
class guiList {
    inherit guiObject
    variable guiBuilder 
    variable childrenCount
    variable listBox
    array set buttons {add 0 delete 2 edit 1 up {} down {}}
    constructor {frame xuiObject gBuilder} {
	set subject $xuiObject
	set guiBuilder $gBuilder
	set label [$subject getLabel]
	set orient vertical
	set contframe [ frame $frame.f]
	set scwin [ScrolledWindow $contframe.scwin]
	set listBox [ ListBox [$scwin getframe].listbox  -multicolumn 0 \
	-background white -height 8 -selectbackground #00008B \
	-selectforeground white]
	$listBox bindText <Button-1> [code $this selectItem ]
	$listBox bindImage <Button-1> [code $this selectItem ]
	$listBox bindText <Double-Button-1> [code $this editSelected ]
	$listBox bindImage <Double-Button-1> [code $this editSelected ]
	$scwin setwidget $listBox
	pack [label $contframe.label -text $label ] -fill x 
	set bbox [ ButtonBox $contframe.bbox -orient $orient]
	switch $orient {
	    vertical {
		pack $bbox -side right
	    }
	    horizontal {
		pack $bbox -side bottom
	    }
	    
	}
	$bbox add -text Add -command [code $this addNewItem]
	$bbox add -text Edit -command [code $this editSelected]
	$bbox add -text Delete -command [code $this deleteSelected]
	pack $scwin -fill both	-expand true
	pack $contframe -fill both -expand true
	foreach element [$subject getChildren] {
	    addItem $element
	}
    }
    method sync {}
    method getText {}
    method selectItem { item }
    method addNewItem {{position end}}
    method addItem { xuiObject {position end}}
    method editSelected {args}
    method deleteSelected {}
    method moveItemUp { position }
    method moveItemDown { position }
}


body guiList::deleteSelected { } {
    foreach lbitem [$listBox selection get] {
	$subject deleteChild [$listBox itemcget $lbitem -data]
	$listBox delete $lbitem
    }
}

body guiList::selectItem { item } {	    
    $listBox selection set $item
}

body guiList::addItem { xuiObject {position end}} {
    if {[string length [set text [$xuiObject getText]]] > 40} {
        set text [string range $text 0 40](...)
    }
    $listBox insert end  [unique::newId] \
	    -text $text \
	    -data $xuiObject -image listicon.gif
}			    

body guiList::addNewItem {{position end}} {
    set grab [grab current]
    set xui [$subject newChild]
    #set w .[string trimleft $this ::]
    set w .[unique::newId]
    set dialog [Dialog $w  \
	    -title "Add new Element" -separator 1 \
	    -default 0 -cancel 1 -modal local]
    wm protocol $w WM_DELETE_WINDOW { ; }  	    
    $dialog add -text Ok
    $dialog add -text Cancel
    $dialog configure -cancel 1
    set frame [$dialog getframe]
    set gui [$guiBuilder render $frame $xui]
    switch [$dialog draw] {
	1 {
	    delete object $gui
	    delete object $xui
	    destroy $dialog
	} 0 {
	    delete object $gui
	    destroy $dialog
	    $subject insertChild $xui
	    addItem $xui
	} default {
	    error {should never occur}
	}
    }
    catch {grab set $grab}
}

body guiList::editSelected { args } {
    set grab [grab current]
    set item [lindex [$listBox selection get] 0]
    if ![llength $item] return {}
    set oldxui [$listBox itemcget $item -data]
    set xui [ $oldxui clone]
    set dialog [Dialog .[unique::newId] \
	    -title "Edit Element" -separator 1 -default 0 -cancel 1]
    $dialog add -text Ok
    $dialog add -text Cancel
    $dialog configure -cancel 1
    set frame [$dialog getframe]
    set gui [$guiBuilder render $frame $xui]
    switch [$dialog draw] {
	1 {
	    delete object $gui
	    delete object $xui
	    destroy $dialog
	} 0 {
	    delete object $gui
	    destroy $dialog
	    $subject replaceChild $oldxui $xui
	    if {[string length [set text [$xui getText]]] > 40} {
                 set text [string range $text 0 40](...)
            }
	    $listBox itemconfigure $item -text $text -data $xui
	} default {
	    error {should never occur}
	}
    }
    grab set $grab
}

body guiList::getText {} {
}

body guiList::moveItemUp { position } {
}

body guiList::moveItemDown { position } {
}


