
class guiMultipleChoice {
    inherit guiObject
    variable listBox
    variable nameMap
    constructor {frame xuiObject} {
	set subject $xuiObject
	set label [$subject getLabel]
	set contframe [ frame $frame.f]
	set scwin [ScrolledWindow $contframe.scwin]
	set listBox [ ListBox [$scwin getframe].listbox  -multicolumn 0 \
	-background white -height 8 -selectbackground #00008B \
	-selectforeground white]
	$listBox bindText <Button-1> [code $this toggleItem ]
	$listBox bindImage <Button-1> [code $this toggleItem ]
	$scwin setwidget $listBox
	pack [label $contframe.label -text $label ] -fill x 
	pack $scwin -fill both	-expand true
	pack $contframe -fill both -expand true
   	foreach {name text} [$subject getChoices] {
	    #puts "Adding $name $text"
	    addItem $name $text
	}
	foreach name [$subject getSelected] {
	    toggleItem $nameMap($name)
	}
    }
    method sync {}
    method addItem { name text }
    method toggleItem { item }
}


body guiMultipleChoice::addItem { name text} {
    set id [unique::newId] 
    set nameMap($name) $id
    $listBox insert end  $id \
	    -text $text \
	    -data $name -image unchecked
}			    

body guiMultipleChoice::toggleItem { item } {
    switch [$listBox itemcget $item -image] {
       checked {
	  $listBox itemconfigure $item -image unchecked
       } default {
      	  $listBox itemconfigure $item -image checked
       }
    }
    sync
}			    

body guiMultipleChoice::sync {} {
    set result ""
    foreach one [$listBox items] {
       switch [$listBox itemcget $one -image] {
       checked {
	  append result " [$listBox itemcget $one -data]"
      } unchecked {
	 
         #do nothing
	 
      }
    }
 }
    $subject selectItems $result
 }
