

class guiPropertyPages {
    inherit guiObject
    variable elements {}
    variable createdItems
    variable noteBook
    variable contframe
    variable pw
    variable tree
    variable guiBuilder
    variable currentPropertyPageXui
    constructor { frame xuiObject gBuilder} {
        array set createdItems ""
	set subject $xuiObject
	set guiBuilder $gBuilder
	set i 0
	set pw [PanedWindow $frame.pw -side bottom]
	$pw add
	$pw add
	set contframe [$pw getframe 0]
        set scwin [ScrolledWindow $contframe.scwin]
	set tree [Tree $scwin.tree \
                -deltay 22\
                -bg white\
                -showlines true\
                -deltax 14\
                ]
	$tree bindText <ButtonPress-1> \
                "$this selectItem"

	set noteBook [PagesManager [$pw getframe 1].nb]

	# We may have to implement 2 passes if we
	# have to add under a node not yet exists
	set els [getOrderedList [$subject getComponents]]
	set items {}
	foreach item $els {
	    set itemName [$item getName]
	    
	    # If at this point parent does not exist, we just hook it under root

            set parent [$item cget -hookUnder]
	    if ![$tree exists $parent] { set parent root }
	    set newFrame  [$noteBook add $itemName]	    
	    $tree insert end $parent $itemName -text [$item getLabel] \
		    -image [$item cget -icon] -data [list $newFrame $item]
	    lappend items $itemName
	}

	pack $contframe -fill both -expand true
	pack $tree -fill both -expand true
	$scwin setwidget $tree
	pack $scwin -fill both -expand true 
	pack $pw -fill both -expand true                       
	selectItem  [lindex $items 0]
    }
    destructor {
	eval delete object $elements
	eval destroy $noteBook
	eval destroy $contframe
	eval destroy $pw
    }
    method selectItem { node } {
    
        # On the fly creation

        if ![info exists createdItems($node)] {
	    pack forget $noteBook
	    pack forget [$pw getframe 1]
	    foreach {newFrame item} [$tree itemcget $node -data] break;
	    set element [$guiBuilder render $newFrame $item]
	    lappend elements $element
	    set createdItems($node) $item
	    $noteBook compute_size
	    pack $noteBook  -side left -fill both -expand true -padx 4
	    pack [$pw getframe 1] -fill both -expand true
	}
	$tree selection set $node 
	$noteBook raise $node
	set currentPropertyPageXui $createdItems($node)
    }
    method enable {}
    method disable {}
    method queryState {} 
    method getSelectedPropertyPageXui {}
}

body  ::guiPropertyPages::getSelectedPropertyPageXui {} {
    return $currentPropertyPageXui
}

proc getOrderedList { list } {
   set oldList $list
   set list [figureOutOrder $list root]
   
   # The ones that do not have a parent but hookUnder!= root, 
   # We put them under root (this is for example is modle that provides parent
   # is not configured)
   
   foreach el $oldList {
       if [expr [lsearch $list $el] == -1] {
           lappend list $el
	   $el configure -hookUnder root
       }
   }
   return $list
}

proc figureOutOrder { list start } {
    set newList [ getAllThatHookUnder $list $start ]
    foreach one $newList {
	lremove list $one
    }
    set ordered $newList
    foreach one $newList {
	set ordered [concat $ordered [figureOutOrder $list [$one getName] ]]
    }
    return $ordered 
}

proc getAllThatHookUnder { list hookPoint } {
    set result {}
    foreach one $list {
        if ![llength [$one cget -hookUnder]] {
	    $one configure -hookUnder root
	}
	if ![string compare [$one cget -hookUnder] $hookPoint] {
	    lappend result $one
	}
    }

    return $result
}
