
class guiString  {
    inherit guiObject guiLabeled
    protected variable labelEntry
    variable value
    constructor {frame xuiString} {
	set subject $xuiString
	set labelEntry [LabelEntry $frame.le -textvariable [scope value]]
	$labelEntry configure -label [$subject getLabel]
	$labelEntry configure -wraplength 240 -labeljustify right
	$labelEntry configure -width [$subject getWidth]
	switch [$xuiString getClasses] {
	    password {
	        $labelEntry configure -show *
	    }
	}
	pack $frame.le.e -expand 0 -anchor w -side left
	pack $frame.le -expand 0 -anchor w -side left
	if ![string length [set value [$subject getValue]]] {
	    set value [set default [$subject getDefault]]
	}
	trace variable [scope value] w [code $this valueChanged]
	pack $labelEntry
	sync
    }
    method sync {}
    method valueChanged {args}
    method enable {}
    method disable {}
    method queryState {}
    method getLabelLength {} { 
	return [string length [$subject getLabel]]
    }
    method setLabelLength { length } { 
	$labelEntry configure -labelwidth $length 
    }
}


body guiString::valueChanged {args} {
    sync
}

body guiString::sync {} {
    $subject setValue $value
}

body guiString::enable {} {
    set state 1
    $labelEntry configure -state normal
}

body guiString::disable {} {
    set state 0
    $labelEntry configure -state disabled
}

body guiString::queryState {} {
    return $state
}


