
class guiStringDirectory  {
    inherit guiString
    variable button
    constructor {frame xuiString} { 
        guiString::constructor $frame $xuiString
    } {
        
        set button [Button $frame.b -image openFolder.gif]
	$button configure -command [code $this askDirectory]
	pack $button -side left -padx 3 -anchor w
	}
   method enable	
   method disable
   method askDirectory
}

body guiStringDirectory::askDirectory {} {
    set title [$labelEntry cget -label]
    set initialdir $value
    if ![file isdirectory $initialdir] {
        set initialdir /
    }
    if [catch {set directory [tkgetdir::tk_getDirectory -initialdir $initialdir -title $title]}] {
	
	# If we do not have access to the directory (wrong permissions) just open default /

	set directory [tkgetdir::tk_getDirectory -initialdir /  -title $title] 
    }
    if [string length $directory] {
        set value $directory
        sync
    }
}

body guiStringDirectory::enable {} {
    $button configure -state normal
    guiString::enable
}

body guiStringDirectory::disable {} {
    $button configure -state disabled
    guiString::disable
}

