

class guiStructure {
    inherit guiObject
    variable elements
    variable containerFrames
    variable bframe
    constructor {frame xuiObject guiBuilder} {
	set subject $xuiObject
	set surrFrame $frame
	if ![string compare [$subject getStyle] normal] {
	    set bframe [TitleFrame $frame.tf -relief groove \
		    -text [$subject getLabel]]
	    set surrFrame [$bframe getframe]
	} else {
	    set surrFrame [set bframe [frame $frame.tf]]
	}
	pack $bframe -fill both -expand true
	switch [$subject getAlign] {
	    horizontal {
		set side left
	    } vertical {
		set side top
	    } default {
		set side top
	    }
	}
	set labeled {}
	set maxLabelSize 0
	set i 0
	foreach structureItem [$subject getComponents] {
	    set newFrame [frame $surrFrame.$i]
	    lappend containerFrames $newFrame
	    set gui [$guiBuilder render $newFrame $structureItem]
	    lappend elements $gui
	    incr i
	    pack $newFrame -side $side  -expand true -fill both -anchor w
	    if [ $gui isa guiLabeled ] {
		lappend labeled $gui
		if [expr [$gui getLabelLength] > $maxLabelSize] {
		    set maxLabelSize [$gui getLabelLength]
		}
	    }
	}
	if [expr $maxLabelSize > 40] {
	set maxLabelSize 40
	}
	foreach element $labeled {
	    $element setLabelLength $maxLabelSize
	}
    }
    destructor {
	eval delete object $elements
	eval destroy $containerFrames
	eval destroy $bframe
    }
    method enableAll {}
    method disableAll {}
    method enable {}
    method disable {}
    method queryState {}
}


body guiStructure::enableAll {} {
    foreach element $elements {
	$element enable
    }
}



body guiStructure::disableAll {} {
    foreach element $elements {
	$element disable
    }
}


body guiStructure::enable {} {
    set state 1
    enableAll
}

body guiStructure::disable {} {
    set state 0
    disableAll
}

body guiStructure::queryState {} {
    return $state
}





