# xuiAlternateCreator.tcl --

# alternateCreator --
#   Is derived from xuiStructureCreator. Things we need to take care are
# selecting the default value

class alternateCreator {
    inherit structureCreator
    method createObject {token xuiBuilder}
    method loadValueFromNode
    method loadValue
    method loadDefault
}

body alternateCreator::createObject {token xuiBuilder} {
   if [string length [set parentName [$xuiBuilder cget -currentParentName]]] {
      set name $parentName.[dom::getAttribute $token name]
    } else {
       set name ::#auto
    }
    return [xuiAlternate $name]
}

body alternateCreator::loadValueFromNode {valueToken object xuiBuilder} {
        structureCreator::loadValueFromNode $valueToken $object $xuiBuilder
	$object selectComponentByName \
	[dom::getTagName [lindex [dom::getElements $valueToken] 0]]
}
 
body alternateCreator::loadValue {token object xuiBuilder} {
    if ![ catch "set valueToken [dom::rp $token value]" ] {
        $this loadValueFromNode $valueToken $object $xuiBuilder
    } else {
        #$object selectComponent [lindex [$object getComponents] 0]
    }
}     

body alternateCreator::loadDefault {token object xuiBuilder} {
    if ![ catch "set value [dom::getText [dom::rp $token default]]" ] {
       $object setDefault $value
    } else {
       $object selectComponent [lindex [$object getComponents] 0]
       $object setDefault [$object getSelectedComponentName]
    }
}     

