
class booleanCreator {
    inherit objectCreator
    method createObject {token xuiBuilder}
    method loadValueFromNode
    method loadDefaultFromNode
}

body booleanCreator::createObject {token xuiBuilder} {
    if [string length [set parentName [$xuiBuilder cget -currentParentName]]] {
        set name $parentName.[dom::getAttribute $token name]
    } else {
       set name ::#auto
    }
    return [xuiBoolean $name]
}

body booleanCreator::loadValueFromNode {valueToken object xuiBuilder} {
	set val [dom::getText $valueToken]
        switch $val {
	1 {
	    $object setValue
	} 0 {
	    $object clearValue
	}
	}
}

body booleanCreator::loadDefaultFromNode {defaultToken object xuibuilder} {
       $object setDefault [dom::getText $defaultToken]
}
