# xuiBuilder.tcl --


# xuiBuilder --
#    This class provides a factory object. It creates xuiObjects from XML
# descriptions. The XML description is passed as a TclDOM token.
# How the tags are handled is specified by adding Creators to the xuiBUilder
# and specifying the tags the creator is responsible for.
# To add support for creating xuiLabel objects, the creator xuiLabel is added.

class xuiBuilder {

    variable objectCreators 
    public variable currentParentName {}

constructor {args} {
    eval array set objectCreators $args
}
    method renderDocument { token }
    method loadValueFromNode { token object }
    method handleObject { token }
    method addCreator { tag object }
}

body xuiBuilder::addCreator { tag object } {
      set objectCreators($tag) $object
}

body xuiBuilder::loadValueFromNode { token object } {
    set objectClass [$object getXuiClass]
    $object reset
    $objectCreators($objectClass) loadValueFromNode $token $object $this
}

# Returns list with all elements created

body xuiBuilder::renderDocument { token } {
    set currentParentName {}
    set token [dom::document cget $token -documentElement]
    foreach element [dom::getElements $token] {
	lappend result [handleObject $element]
    }
    return $result
}

body xuiBuilder::handleObject { token } {
    $objectCreators([dom::getTagName $token]) create $token $this
}

class objectCreator { 
    method create {token xuiBuilder}
    method createObject {token xuiBuilder}
    method processSyntax {token obj xuiBuilder}
    method configName {token object xuiBuilder}
    method setXuiClass {token object xuiBuilder}
    method setClasses { token object xuiBuilder} 
    method configLabel {token object xuiBuilder}
    method loadValue {token object xuiBuilder}    
    method loadDefault {token object xuiBuilder}
    method extraStuff {token object xuiBuilder}
}

body objectCreator::create {token xuiBuilder} {
    set object [$this createObject $token $xuiBuilder]
    $this setXuiClass $token $object $xuiBuilder
    $this setClasses $token $object $xuiBuilder
    $this configName $token $object $xuiBuilder
    $this configLabel $token $object $xuiBuilder
    $this processSyntax $token $object $xuiBuilder
    $this loadValue $token $object $xuiBuilder
    $this loadDefault $token $object $xuiBuilder
    $this extraStuff $token $object $xuiBuilder
    return $object
}

body objectCreator::configName {token object xuiBuilder} {
    $object setName [dom::getAttribute $token name]
    $object setTagName [dom::getAttribute $token tagname]
}

body objectCreator::configLabel {token object xuiBuilder} {
    $object setLabel [mesg::get [dom::getAttribute $token label]]
}


body objectCreator::loadValue {token object xuiBuilder} {
    if ![ catch "set valueToken [dom::rp $token value]" ] {
	  $this loadValueFromNode $valueToken $object $xuiBuilder
    }
}

body objectCreator::loadDefault {token object xuiBuilder} {
    if ![catch "set defaultToken [dom::rp $token default]"] {
    $this loadDefaultFromNode $defaultToken $object $xuiBuilder
    }
}
	
body objectCreator::processSyntax { token object xuiBuilder} {
}

body objectCreator::setXuiClass { token object xuiBuilder} {
        $object setXuiClass [dom::getTagName $token]
}

body objectCreator::setClasses { token object xuiBuilder} {
        $object setClasses [dom::getAttribute $token classes]
}

body objectCreator::extraStuff { token object xuiBuilder} {
}

