
class choiceCreator {
    inherit objectCreator
    method processSyntax {token object xuiBuilder}
    method createObject {token xuiBuilder}
    method loadValueFromNode
    method loadDefaultFromNode    
}

body choiceCreator::createObject {token xuiBuilder} {
    if [string length [set parentName [$xuiBuilder cget -currentParentName]]] {
	set name $parentName.[dom::getAttribute $token name]
    } else {
	set name ::#auto
    }                        
    return [xuiChoice $name]
}

body choiceCreator::loadValueFromNode {valueToken object xuiBuilder} {
        $object selectItem [dom::getText $valueToken] 
}

body choiceCreator::loadDefaultFromNode {defaultToken object xuiBuilder} {
        $object setDefault [dom::getText $defaultToken]
}

body choiceCreator::processSyntax { token object xuiBuilder} {
     set syntaxToken [dom::rp $token syntax]
     foreach item [dom::myGetElementsByTagName $syntaxToken option] {
        $object addChoice \
	[dom::getAttribute $item name] \
	[mesg::get [ dom::getAttribute $item value]]
     }
}

