

# includeCreator --
#    This is used to process <include> directives in property pages
# definitions. At instantation time the directive definition object is
# passed as a parameter. When it encounters a include tag, it looks for the
# name attribute and fetchs the appropriate directive.

class includeCreator {
     variable dirDef
     variable rootConf
     constructor { directiveDef } {
     set dirDef $directiveDef
     }
     method create {token xuiBuilder}
}

body includeCreator::create {token xuiBuilder} {
    set name [dom::getAttribute $token name]
    set dir [$dirDef getDirectiveByName [string tolower $name]]
    if ![llength  $dir] {
     error "Include directive not encountered: $name"
    } else {
    return $dir
    }
}

