
class listCreator {
    inherit objectCreator
    method processSyntax {token object xuiBuilder}
    method createObject {token xuiBuilder}
    method loadValueFromNode
    method loadDefaultFromNode    
}

body listCreator::createObject {token xuiBuilder} {
    if [string length [set parentName [$xuiBuilder cget -currentParentName]]] {
	set name $parentName.[dom::getAttribute $token name]
    } else {
	set name ::#auto
    }                        
    return [xuiList $name]
}

body listCreator::loadValueFromNode {valueToken object xuiBuilder} {
    foreach itemToken [dom::getElements $valueToken] {   
	set listItem [$object newChild] 
	$xuiBuilder loadValueFromNode $itemToken $listItem
	$object insertChild $listItem
    }
}


body listCreator::loadDefaultFromNode {defaultToken object xuiBuilder} {
    if ![llength [$object getChildren]] {
    foreach itemToken [dom::myGetElementsByTagName $defaultToken item] {
	set listItem [$object newChild] 
	$xuiBuilder loadValueFromNode $itemToken $listItem
	$object insertChild $listItem
    }
    }
}

body listCreator::processSyntax { token object xuiBuilder} {
    set syntaxToken [dom::rp $token syntax]
    set prototypeToken [lindex [dom::getElements $syntaxToken] 0]
    $xuiBuilder configure -currentParentName {}
    $object setPrototype [$xuiBuilder handleObject $prototypeToken]
}




