
class structureCreator {
    inherit objectCreator
    method processSyntax {token object xuiBuilder}
    method createObject {token xuiBuilder}
    method loadValueFromNode
    method loadDefaultFromNode    
}

body structureCreator::createObject {token xuiBuilder} {
    if [string length [set parentName [$xuiBuilder cget -currentParentName]]] {
	set name $parentName.[dom::getAttribute $token name]
    } else {
	set name ::#auto
    }    
    return [xuiStructure $name]
}

body structureCreator::loadValueFromNode {valueToken object xuiBuilder} {
    foreach element [dom::getElements $valueToken] {
	set strObject [$object getComponentByName [dom::getTagName $element]]
	$xuiBuilder loadValueFromNode $element $strObject
    }
}

body structureCreator::loadDefaultFromNode {defaultToken object xuiBuilder} {
    $object setDefault [dom::getText $defaultToken]
}

body structureCreator::processSyntax { token object xuiBuilder} {
     $object setAlign [dom::getAttribute $token align]
     $object setStyle [dom::getAttribute $token style]
     set syntaxToken [dom::rp $token syntax]
     foreach component [dom::getElements $syntaxToken] {
	 $xuiBuilder configure -currentParentName $object
	 $object addComponent [ $xuiBuilder handleObject $component]
     }
}

