
class xuiAlternate {
    inherit xuiStructure
    constructor {} {
    setXuiClass alternate
    }
    variable selected {}
    variable defaultSelect {}
    method selectComponent { xuiObject }
    method selectComponentByName { componentName }
    method getSelectedComponent {}
    method getSelectedComponentName {}
    method getText {}
    method clone 
    method copyClone { clone }
    method reset {}
    method setDefault
    method getDefault
}
body xuiAlternate::getDefault { } {
        return $defaultSelect
}
                   
body xuiAlternate::setDefault { name } {
    set defaultSelect $name
    selectComponentByName $name
}

body xuiAlternate::reset {} {
    selectComponentByName $defaultSelect
    xuiStructure::reset
}

body xuiAlternate::selectComponentByName { componentName } {
    selectComponent $nameMap($componentName)
}

body xuiAlternate::selectComponent { xuiObject } {
    set selected $xuiObject
}

body xuiAlternate::getSelectedComponent {} {
    return $selected
}

body xuiAlternate::getSelectedComponentName {} {
    return [$selected getName]
}


body xuiAlternate::getText {} {
    if [llength $selected] {
        $selected getText
    } else {
    return {}
    }
}

body xuiAlternate::clone {{parentName {::#auto}}} {
   set clone [xuiAlternate $parentName.$name]
   copyClone $clone
   return $clone
}
 
body xuiAlternate::copyClone { clone } {
   xuiStructure::copyClone $clone
   if [llength $selected] {
       $clone selectComponentByName [$selected getName]
   } else {
       #puts "cloning $this to $clone not selected"
   }
   $clone setXuiClass $xuiClass
} 


