
class xuiList {
    inherit xuiObject
    variable children {}
    variable prototype {}
    constructor {} { 
    setXuiClass list
    }
    destructor {
    delete object $prototype
    eval delete object $children
    }
    method setPrototype { xuiObject }
    method getPrototype { } { return $prototype }
    method getChildren {}
    method getChildrenByName {name}
    method newChild {}
    method deleteChild { xuiObject }

    
    method clear {} { foreach child $children { $this deleteChild $child} }
    method insertChild { xuiObject {position {}}}
    method replaceChild { oldChild newChild}
    method getText {}
    method clone 
    method copyClone { clone }
    method reset {}
}
	 
body xuiList::reset {} {
    clear
}

body xuiList::clone {{parentName {::#auto}}} {
   set clone [xuiList $parentName.$name]
   copyClone $clone
   return $clone
}

body xuiList::copyClone {clone} {
   xuiObject::copyClone $clone
   $clone clear
   $clone setPrototype [ $prototype clone ]
   foreach child [getChildren] {
      $clone insertChild [$child clone]
   }
   $clone setXuiClass $xuiClass
}

body xuiList::setPrototype { xuiObject } {
    set prototype $xuiObject
}

body xuiList::getChildren {} {
    return $children
}

body xuiList::getChildrenByName { name } {
    set result {}
    foreach one $children {
       if ![string compare [$one getName] $name] {
           lappend result $one
       }
    }
    return $result
}

body xuiList::newChild {} {
    return [$prototype clone]
}

body xuiList::deleteChild { xuiObject } {
    delete object $xuiObject
    set pos [lsearch -exact $children $xuiObject]
    set children [lreplace $children $pos $pos]
}

body xuiList::insertChild { xuiObject {position {}}} {
    lappend children $xuiObject
}

body xuiList::getText {} {
    set result {}
    foreach item $children {
	append result " [$item getText]"
    }
    return $result
}

body xuiList::replaceChild { oldChild newChild } {
    set pos [lsearch -exact $children $oldChild]
    set children [lreplace $children $pos $pos $newChild]
}

