# xuiObject --
#   Base class from which all other xui objects are derived from/
#
# clone, copyClone. Are used to duplicate objects. Clone creates an identical 
# clone of the current object. Copy clone is used to copy the contents of
# a xuiObject to another existing xuiObject
#
# visitor (from the visitor pattern) will be used for serializing to XML

class xuiObject {
    protected variable name {}
    protected variable tagName {}
    protected variable label {}
    variable xuiClass {}
    variable classes {}

    # Added to support module / directive help

    public variable helpReference {}
    method getName {} { return $name }
    method setName { newName } { set name $newName}
    method getTagName {} 
    method setTagName { newTagName } 
    
    method getXuiClass {} { return $xuiClass }
    method setXuiClass { newXuiClass } { set xuiClass $newXuiClass}
    method getLabel {} { return $label }
    method setLabel { newLabel } { set label $newLabel}
    method clone 
    method copyClone { clone }
    method visitor {}
    method getClasses {}
    method setClasses { classList }
    method addClass { class }
    method addClasses { classList }
    method doYouBelongTo { class }
    method reset {} {}
}

body xuiObject::getTagName {} {
    if ![llength $tagName] {
        return $name
    } else {
        return $tagName
    }
}

body xuiObject::setTagName { newTagName } {
    set tagName $newTagName
}


body xuiObject::clone {{parentName {::#auto}}} {
   set clone [xuiObject $parentName.$name]
   copyClone $clone
   return $clone
}

body xuiObject::copyClone { clone } {
    $clone setName $name
    $clone setTagName $tagName
    $clone setLabel $label
    $clone setXuiClass $xuiClass
    $clone setClasses $classes
    $clone configure -helpReference $helpReference
}



body xuiObject::getClasses {} {
    return $classes
}

body xuiObject::setClasses { classList } {
    set classes $classList
}

body xuiObject::addClasses { classList } {
    foreach class $classList {
	lappend classes $class
    }
}

body xuiObject::addClass { class } {
	lappend classes $class
}

body xuiObject::doYouBelongTo { class } {
    if { [lsearch $classes $class ] == -1 } {
	return 0 
    } else {
	return 1    
    }
}

