
class xuiString {
    inherit xuiObject

    variable value {}
    variable default {}
    variable width 20
    
        constructor {} {
    setXuiClass string
    }   
    method setValue {newValue} {
	if {[$this doYouBelongTo directory] \
		|| [$this doYouBelongTo file]} {
	    # Do not know how this affects windows,
	    # so for now only for unix
	    global tcl_platform
	    if [string compare $tcl_platform(platform) windows] {
		set newValue [file nativename $newValue]
	    }
	} 
	set value $newValue
    }
    method getValue {} {return $value}


    method setDefault {newDefault} {set default $newDefault}
    method getDefault {} {return $default}
    method setWidth {newWidth} {set width $newWidth}
    method getWidth {} {return $width}


    method getText {} { return $value }
    method clone 
    method copyClone { clone }
    method reset {}
}

body xuiString::reset {} {
   set value $default
}

body xuiString::clone {{parentName {::#auto}}} {
   set clone [xuiString $parentName.$name]
   copyClone $clone
   return $clone
}

body xuiString::copyClone { clone } {
   xuiObject::copyClone $clone
   $clone setValue $value
   $clone setDefault $default
   $clone setWidth $width
   $clone setXuiClass $xuiClass
}






