
class xuiStructure {
    inherit xuiObject

    variable children {}
    variable nameMap
    variable align horizontal

    variable style none

    constructor {} {
        array set nameMap {}
    setXuiClass structure

    }
    destructor {
        eval delete object $children
    }
    method getComponentByName { name }
    method addComponent { xuiObject }
    method getText {}
    method getComponents {}
    method clear {}
    method forgetComponents {}
    method insertComponent {xuiObject name}
    method clone 
    method copyClone { clone }
    method setAlign { newAlign } {  set align $newAlign }
    method getAlign {} { return $align }
    method setStyle { newStyle } {  set style $newStyle }
    method getStyle {} { return $style }
    method reset {}
}
 
body xuiStructure::reset {} {
    foreach child $children {
        $child reset
    }
}
 
body xuiStructure::clone {{parentName {::#auto}}} {
   set clone [xuiStructure $parentName.$name]
   copyClone $clone
   $clone setXuiClass $xuiClass  
   return $clone
}

body xuiStructure::copyClone { clone } {
   xuiObject::copyClone $clone
   $clone clear
   foreach component $children {
      $clone addComponent [$component clone $clone]
   }
   $clone setAlign $align
   $clone setStyle $style


}


body xuiStructure::forgetComponents {} {
   set children {}
   catch {unset nameMap}
   variable nameMap
}

body xuiStructure::clear {} {
   foreach child $children {
      delete object $child
   }
   set children {}
   catch {unset nameMap}
   variable nameMap
}

body xuiStructure::getComponentByName { name } {
    if [info exists nameMap($name)] {
	return $nameMap($name)
    } else {
	error "No component with name $name in object $this"
    }
}

body xuiStructure::addComponent { xuiObject } {
    lappend children $xuiObject
    array set nameMap [list [$xuiObject getName] $xuiObject]
}

body xuiStructure::getText {} {
    set result {}
    foreach object $children {
	append result "[$object getText] "
    }
    
    return [string trimleft $result ]
}

body xuiStructure::getComponents {} {
    return $children
}

body xuiStructure::insertComponent { xuiObject name} {    
     set children [linsert $children \
	     [lsearch -exact $nameMap($name)] $xuiObject]   
     array set nameMap [list [$xuiObject getName] $xuiObject] 
}

     

