# apache.tcl

# apachePlugIn --
#    Provides functionality for configuring the Apache webserver
#
# TO-DO: Convert public variables to parameters passed at construction time

class apachePlugIn {
    inherit plugIn
    
    # Object used to convert property pages -> httpd.conf format
    
    public variable dumper
    
    # Object used to store/load values from property pages
    
    public variable ppManager
    
    # Object carrying definition of  property pages. We can ask it a
    # property page by its name and it will answer.
    
    public variable ppDef
    
    # This is not used as of now. It will be used to access configuration files
    
    public variable configurationFilesManager
    
    # Namespace we are hooking to
 
    public variable namespace
    
    # Used to keep track of which nodes
    
    public variable nodeManagement
    
    # Configuration document

    public variable confDoc
    
    # Assigns ppages to nodes 
    
    public variable moduleManager
    
    # Comments describing the server
    
    public variable serverDescription
    
    # Location of the httpd binary (to get version)

    public variable httpd
    
    # Location of the configuration files

    public variable configurationFiles

    # Location of the server root

    public variable serverRoot
    
    
    # All this stuff needs to be refactored into a configuration object
    #
    # tail: number or full (full: display full)
    #
    # {{filename description} {...}}
    
    variable configurationFilesList
    variable _mappingConfigurationFiles
    public variable logFilesList
    variable _mappingLogFiles
    
    variable _wizards 

    # Backup directory
    public variable backupsdir

    # hack needed for restart
    public variable apmanager

    # Property pages for enabling/disabling modules
    
    variable modulePP
    
    public variable rootNode
    variable mainServer
    variable servermanagement
    
    variable commands
    constructor {} {
        array set commands {}
	array set _mappingLogFiles {}
	array set _mappingConfigurationFiles {}
	set modulePP [ ::libgui::createXuiFromText {
	    <propertyPage name="modulePP" label="module_management">
	        <choice name="moduleConf" label="module_conf_PP" 
                        classes="multipleChoice">
	        <syntax><option name="bla" value="bla" /></syntax>
	        <default>bla</default>
	        </choice>
	    </propertyPage>
	} ]
	array set _wizards {}
	set _wizards(createBackUp) [::libgui::createXuiFromFile $::apacheplugin::apacheplugindir/backupWizard.xml ]
	set _wizards(restoreBackUp) [::libgui::createXuiFromFile $::apacheplugin::apacheplugindir/restoreWizard.xml ]
    }
	
    method _registerWithNamespace {}
    method _inquiryForPropertyPages  { node docInfo}
    method _inquiryForWizard { node docInfo}
    method _inquiryForMenu { node docInfo}
    method _inquiryForRightPaneContent { node docInfo}
    method _receivedPropertyPages { node docInfo propertyPageList }
    method _receivedWizard { node docInfo wizardPageList }
    method _executeCommand { node docInfo}
    
    method init
    method die
    method _createNodes { node } 
    method _deleteNodes { node } 
    method _addNode { node container }
    method _saveConfig { }
    
    method addNewManagementCommand {name action icon} 
    
    method deleteNodeRequest
}


body apachePlugIn::die {} {
    _deleteNodes $rootNode
}


body apachePlugIn::_deleteNodes { node } {
    foreach child [ $nodeManagement getPlugInNodeChildren $node] {
          _deleteNodes $child
    }
    $nodeManagement removeNode $node
}

# apachePlugIn::addNewManagementCommand --
#   Used to add new management commands that will get displayed in the right
# pane when the server management node is selected

body apachePlugIn::addNewManagementCommand {name action icon} {
    set commands($name) [list $action $icon]
}

body  apachePlugIn::_receivedPropertyPages { node docInfo propertyPageList } {
    set container [ $nodeManagement getContainer $node ]
    set name [ $nodeManagement getNodeName $node ]
    switch $name {
	moduleconf {
	    set pp [lindex $propertyPageList 0]
	    foreach one [$moduleManager getEnabledModuleList] {
		$moduleManager disableModule $one
		
	    }
	    $moduleManager enableModule coredirs
	    
	    foreach one [$pp.moduleConf getSelected] {
		$moduleManager enableModule $one
	    }
	    
	    set f [open $::apacheplugin::disabledModulesFile w]
	    foreach one [$moduleManager getDisabledModuleList] {
		puts $f $one
	    }
	    close $f
	    

	} default {
	    if [string length $container] {
		foreach pp $propertyPageList {
		    $ppManager savePropertyPage $pp $confDoc $container
		}
	    }
	}
    }
    if [catch {_saveConfig} mesg] {
	return [list error $mesg]
    } else {
	return [list ok {}]
    }
}

body apachePlugIn::_saveConfig {} {

    # TO-DO: Add the capability to have templates. We need a configuration
    # files manager to get rid of this.
    
    $dumper configure -includeroot [file dirname $configurationFiles]
    $dumper dump $confDoc $configurationFiles

}

body apachePlugIn::_receivedWizard { node docInfo wizardPageList } {
    array set documentInfo $docInfo
    
    set container [$nodeManagement getContainer $node]
    set name [ $nodeManagement getNodeName $node ]
    
    # Need to check here section can be created under that node (e.g directory under files)
    
    set page [lindex $wizardPageList 0]
    switch $documentInfo(documentSubtype) {
       location - directory - files  {
	    set name [[$page getComponentByName sectionName] getValue]
	   if [string length $name] {
	       _addNode $node [$confDoc addContainer $container $name $documentInfo(documentSubtype)]
	       if [catch {_saveConfig} mesg] {
		   return [list error $mesg]
	       } else {
		   return {info {Section added successfully}}
	       }
	   } else {
	       return [list error "Please fill a value"]
	   }
       } virtualhost {
	   set name [[$page getComponentByName sectionName] getValue]
	   if [string length $name] {
	       _addNode $rootNode [$confDoc addContainer [$confDoc getRootContainer] $name $documentInfo(documentSubtype) ]
	       if [catch {_saveConfig} mesg] {
		   return [list error $mesg]
	       } else {
		   return {info {Section added successfully}}
	       }
	   } else {
	       return [list error "Please fill a value"]
	   }	       
       } createBackUp {
	   if [catch {apmanager::createBackUp $backupsdir $configurationFiles \
		   [$page.backup getValue]} kk] {
	       return [list error $kk]
	   } else {
	       return {info {Backup successfully created}}
	   }
       } restoreBackUp {
	   if [catch {::apmanager::restoreBackUp \
		   [::helper::readFile [$page.backup getSelected]]} kk] {
	       return [list error $kk]
	   } else {
	       $apmanager restartInstallation $this
	       return {info {Backup successfully restored}}
	   }
       } default {
	   error "Container named $name not recognized"
	}
    }
    if [catch {_saveConfig} mesg] {
	return [list error $mesg]
    } else {
	return [list ok {}]
    }
}

body apachePlugIn::init {} {

    # Should probably take it out of apmanager namespace

    set configurationFilesList \
	    [apmanager::getListOfConfigFilesToBackUp $configurationFiles]
    set logFilesList \
	    [apmanager::getListOfLogFiles $configurationFiles]
    _createNodes $rootNode
    if ![::apmanager::areThereBackUps $backupsdir] {
	apmanager::createBackUp $backupsdir $configurationFiles "Initial configuration files"
    }
}

body apachePlugIn::_inquiryForPropertyPages { node docInfo} {
    set result {}
    set name [$nodeManagement getNodeName $node]
    set container [$nodeManagement getContainer $node]
    switch $name {
	moduleconf {
	    set result ""
	    set moduleConf [$modulePP getComponentByName moduleConf]
	    $moduleConf clear
	    foreach mod [$moduleManager getEnabledModuleList] {
		set text [string toupper \
			[string range $mod 0 0]][string range $mod 1 end]
		
		if ![string match coredirs $mod] {
		    $moduleConf addChoice 	$mod $text	
		    append result " $mod"
		}
	    }
	    foreach mod [$moduleManager getDisabledModuleList] {
		set text [string toupper \
			[string range $mod 0 0]][string range $mod 1 end]
		if ![string match coredirs $mod] {
		    $moduleConf addChoice $mod $text	
		}
	    }
	    $moduleConf selectItems $result
	    return [list $docInfo $modulePP]
	} default {
	    # Check which property pages are associated with this type of node
	    
	    foreach pp [$moduleManager getPropertyPagesByNodetypeList $name] {
		# PP is a list that contains: pp page name, skill, hookUnder
		set mypp [$ppDef getPPByName [lindex $pp 0]]
		$mypp configure -hookUnder [lindex $pp 2]
		lappend result $mypp

		# We fill the property page with the values that 
		# we may already have
		
		$ppManager loadPropertyPage $mypp $confDoc $container
	    }
	}
    }
    return [list $docInfo $result]
}

body apachePlugIn::_inquiryForMenu { node docInfo} {
    set name [$nodeManagement getNodeName $node]
#     return [list  [list -type cascade -label "New" -command ""  -childmenu [list \
          [list -type command -label "Virtual host" -command "bla1"] \
	  [list -type command -label "Directory" -command "bla2" -state disabled]] \
       ] \
     [list -type command -label "Delete" -command [comanche::html::encodeURL _action deleteNodeRequest _node $node]]  \
     [list -type separator] \
     [list -type command -label "Cut" -command "bla3" -state disabled] \
     [list -type command -label "Copy" -command "bla4" -state disabled] \
     [list -type command -label "Paste" -command "bla5" -state disabled] \
     [list -type separator] \
     [list -type command -label "Configure" -command [comanche::html::createShowPropertyPagesURL $node {} notag]] \
     ]    
    switch -- $name {
	mainServer {
    return [list  [list -type cascade -label "New" -command ""  -childmenu [list \
      [list -type command -label "Virtual host" -command [comanche::html::createShowWizardURL $node {Virtual host} virtualhost notag]] \
      [list -type command -label "Directory" -command  [comanche::html::createShowWizardURL $node Directory directory notag]] \
	  [list -type command -label "Location" -command  [comanche::html::createShowWizardURL $node Location location notag]] \
	  [list -type command -label "Files" -command   [comanche::html::createShowWizardURL $node Files files notag]]] \
	  ] \
     [list -type separator] \
     [list -type command -label "Configure" -command [comanche::html::createShowPropertyPagesURL $node {} notag]] \
     ]
        } virtualhost {
    return [list  [list -type cascade -label "New" -command ""  -childmenu [list \
	  [list -type command -label "Directory" -command  [comanche::html::createShowWizardURL $node Directory directory notag]] \
	  [list -type command -label "Location" -command  [comanche::html::createShowWizardURL $node Location location notag]] \
	  [list -type command -label "Files" -command   [comanche::html::createShowWizardURL $node Files files notag]]] \
	  ] \
     [list -type command -label "Delete" -command [comanche::html::encodeURL _action deleteNodeRequest _node $node]]  \
     [list -type separator] \
     [list -type command -label "Configure" -command [comanche::html::createShowPropertyPagesURL $node {} notag]] \
     ]	   
	} directory - location {
    return [list  [list -type cascade -label "New" -command ""  -childmenu [list \
	    [list -type command -label "Files" -command   [comanche::html::createShowWizardURL $node Files files notag]]] \
	    ] \
     [list -type command -label "Delete" -command [comanche::html::encodeURL _action deleteNodeRequest _node $node]]  \
     [list -type separator] \
     [list -type command -label "Configure" -command [comanche::html::createShowPropertyPagesURL $node {} notag]] \
     ]	   	   
	} moduleconf {
    return [list  [list -type command -label "Configure" -command [comanche::html::createShowPropertyPagesURL $node {} notag]] \
     ]	 
	} rootNode {
	} servermanagement {
	    set commandMenu {}
		global tcl_platform 
	switch $tcl_platform(tcl_platform) {
	windows { 
	} default {
	    foreach {name value} [array get commands] {
		lappend commandMenu [list -type command -label $name \
			-command [comanche::html::createCommandURL \
			$node $name $name notag]]
	    }
	} }
	    if [::apmanager::areThereBackUps $backupsdir] {
		set status active
	    } else {
		set status disabled 
	    }
	    return [list  [list -type cascade -label "Send Command" -command "" -childmenu $commandMenu] \
		    [list -type separator] \
		    [list -type cascade -label "Backup" -command ""  -childmenu [list \
		    [list -type command -label "Create Backup" -command "[comanche::html::createShowWizardURL $node {Create Backup} createBackUp notag]"] \
		    [list -type command -label "Restore Backup" -command "[comanche::html::createShowWizardURL $node {Restore Backup} restoreBackUp notag]" -state $status]]] \
		    ]
	} default {
	}
    }
   
}

body apachePlugIn::_inquiryForWizard { node docInfo} {
    array set documentInfo $docInfo
    set result {}
    set name [$nodeManagement getNodeName $node]
    set container [$nodeManagement getContainer $node]
    
    # Switch by subtype of wizard vs. type of node
    
    switch $documentInfo(documentSubtype) {
	virtualhost - directory - location - files {
	    array set documentInfo "selectedPageName $documentInfo(documentSubtype)AddWizard"
	    return [list [array get documentInfo] [$ppDef getPPByName $documentInfo(documentSubtype)AddWizard]]
	}
	createBackUp {
	    array set documentInfo "selectedPageName createBackUp"
	    return [list [array get documentInfo] [list $_wizards($documentInfo(documentSubtype))]]
	} 
	restoreBackUp {
	    set backupList [::apmanager::getBackUps $backupsdir]
	    set page $_wizards($documentInfo(documentSubtype))
	    $page.backup clear
	    foreach info [apmanager::getBackUps $backupsdir] {
		# file description time
		set time [clock format [lindex $info 2] \
			-format "%a %d %b"]
		$page.backup addChoice [lindex $info 0] \
			"[lindex $info 1] -- $time"
	    }
	    array set documentInfo "selectedPageName restoreBackUp"
	    return [list [array get documentInfo] [list $page]]
	} default {
	    error "Unknown wizard type $documentInfo(documentSubtype)"
	}
    }
    return $result
}

body apachePlugIn::_executeCommand { node docInfo} {
    global tcl_platform
    set result {}
    array set documentInfo $docInfo
    set commandName $documentInfo(documentSubtype)
    set name [$nodeManagement getNodeName $node]
    set container [$nodeManagement getContainer $node]
    switch $tcl_platform(platform) {
	unix {
	    if [catch {eval exec [lindex $commands($commandName) 0]} result] {
		set code error
	    } else {
		set code ok
	    }
	} windows {
	    set result {Commands for starting/stopping, etc do not work yet \
	            on Windows. Use the ones included with Apache}
	    global env
	    if [catch {exec $env(COMSPEC) /c \
		    [lindex $commands($commandName) 0]} result] {
			set code error
		} else {
			set code ok
		}
	}
    }
    return [list $code $result]
}

# This has to be taken to an external file to be easy to translate.

body apachePlugIn::_inquiryForRightPaneContent { node docInfo} {
    set result ""    
    set container [$nodeManagement getContainer $node]
    set name [$nodeManagement getNodeName $node]
    switch $name {
	serverinfo {
	    append result {<img src="apache_logo.gif">}
	    append result "<h1>[mesg::get apache_server_info]</h1>"
	    global tcl_platform
	    switch $tcl_platform(platform) {
		unix {
		    if ![catch {eval exec $httpd -v} info] {
			append result "<pre>$info</pre>"
		    } else {
			append result \
				[mesg::get apache_server_info_version_error]
			append result "<pre>$info</pre>"	
		    }
		    if ![catch {eval exec $httpd -l} info] {
			append result "<pre>$info</pre>"
		    } else {
			append result \
				[mesg::get apache_server_info_modules_error]
			append result "<pre>$info</pre>"	
		    }
		} windows {
		    set result \
			    {Server information cannot yet be obtained in Windows}
		    #global env
		    #catch {exec $env(COMSPEC) /c \
			    [lindex $commands($commandName) 0]} result
		}
	    }
	}
	logs {
	    set result {}
	    append result {<img src="apache_logo.gif">}
	    append result "<h1>[mesg::get logs_header]</h1>"
	    foreach {logfilenode text} [array get _mappingLogFiles] {
		append result "<img src=\"files.gif\">[comanche::html::createSelectNodeURL $logfilenode $text]<br>"
	    }
	    return $result
	}
	mainConfigurationNode {
	    set result {}
	    append result {<img src="apache_logo.gif">}
	    append result "<h1>[mesg::get config_header]</h1>"
	    foreach {filenode text} [array get _mappingConfigurationFiles] {
		append result "<img src=\"files.gif\">[comanche::html::createSelectNodeURL $filenode $text]<br>"
	    }
	    return $result
	}
	logfile {
	    global tcl_platform
	    switch $tcl_platform(platform) {
	       windows {
		  if [file exists $_mappingLogFiles($node)] {
		     set f [open $_mappingLogFiles($node)]
		     set k {}
		     if ![catch {seek $f -1000 end}] {
			catch {set k [read $f]}
		     } else {
			catch {set k [read $f 1000]}
		     }
		     close $f
		     return <pre>$k</pre>	
		  }
	       } default {
      		  if [catch {exec tail -1000 $_mappingLogFiles($node)} text]  {
     		     return "<pre>Could not access file $_mappingLogFiles($node):\n$text</pre>"
      		  } else {
     		     return <pre>$text</pre>
      		  }
	       }
	    }
	 }
	conffile {
	    if  [catch {open $_mappingConfigurationFiles($node)} f] {
		return "<pre>Could not access file $_mappingConfigurationFiles($node):\n$f</pre>"
	    }
	    regsub -all \< [read $f] {\&lt;} text
	    close $f
	    return <pre>$text</pre>
	}
	moduleconf {
	    append result {<img src="apache_logo.gif">}
	    append result "<h1>[mesg::get module_management]</h1>"
	    append result [mesg::get apache_available_modules]<br>
	    append result [comanche::html::createShowPropertyPagesURL \
		    $node [mesg::get apache_edit_available_modules]]
	    append result \
		    "<h2>[mesg::get apache_available_modules_bundled]</h2>"
	    foreach mod [$moduleManager getEnabledModuleList] {
		if [expr [lsearch -exact  \
			{access actions alias asis auth auth_anon auth_db auth_dbm
		auth_digest autoindex browser cern_meata cgi cookies digest dir dld dll env 
		expires headers imap include info isapi log_agent log_common log_config log_referer 
		mime mime_magic mmap_static negotiation proxy rewrite setenvif so speling status userdir 
		unique_id usertrack vhost_alias } $mod] != -1] {
		    set name [string toupper [string range $mod 0 0]][string range $mod 1 end]
		    append result "<br> <img src=\"[$moduleManager getModuleIcon $mod]\"> <b>$name</b>: [$moduleManager getModuleDescription $mod]  "
		}
	    }
	    append result "<h2>[mesg::get apache_available_modules_thirdparty]</h2>"
	    foreach mod [$moduleManager getEnabledModuleList] {
		if [expr [lsearch -exact {coredirs access actions alias asis auth auth_anon auth_db auth_dbm 
		auth_digest autoindex browser cern_meata cgi cookies digest dir dld dll env 
		expires headers imap include info isapi log_agent log_common log_config log_referer 
		mime mime_magic mmap_static negotiation proxy rewrite setenvif so speling status userdir
		unique_id usertrack vhost_alias } $mod ] == -1] {
		    set name [string toupper [string range $mod 0 0]][string range $mod 1 end]
		    append result "<br> <img src=\"[$moduleManager getModuleIcon $mod]\"> <b>$name</b>: [$moduleManager getModuleDescription $mod]  "
		}
	    }
	} servermanagement {
	    set result [mesg::get apache_server_management_right_pane]
	global tcl_platform
		switch $tcl_platform(platform) {
		windows { 
		append result <br>[mesg::get apache_server_management_right_pane_windows]
} default {
	    foreach {name value} [array get commands] {
		append result "<br><img src=\"[lindex $value 1]\">[comanche::html::createCommandURL \
			$node $name $name tag]"
	    }
}
		}
	    append result {<br><h1>Backups</h1><br>}
	    append result \
		    "<img src=\"files.gif\">[comanche::html::createShowWizardURL \
		    $node {Create Backup} createBackUp tag]<br><br>" 
	    if [::apmanager::areThereBackUps $backupsdir] {
		append result \
			"<img src=\"files.gif\">[comanche::html::createShowWizardURL \
			$node {Restore Backup} restoreBackUp tag]<br>"
	    }
	} rootNode {
	    set result {
		<img src="apache_logo.gif">
		<h1>Apache</h1><br>
	    }
	    append result [mesg::get apache_server_root_right_pane_1]
	    append result { <b>}
	    append result [mesg::get apache_web_server]
	    append result {</b>. <br><br>}
	    append result [mesg::get apache_you_can]
	    append result {:<br> <br> <img src="www.gif"> }
	    append result [comanche::html::createSelectNodeURL $mainServer  [mesg::get configure] ]
	    append result " [mesg::get the_main_web_site]"
	    append result {<br><br> <img src="wheel.gif">}
	    append result [comanche::html::createShowWizardURL \
		    $mainServer [mesg::get Create] virtualhost tag]
	    append result " [mesg::get a_new_virtual_host]"
	    
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node virtualhost]]] {
		#append result  {<br><br>}
		append result  {<br>}
		#append result [mesg::get or_configure_an_existing_one]
		#append result {<br>}
	    } else {
		append result {<br><br> }
		append result [mesg::get apache_no_virtualhosts]
		append result {<br>}
	    }
	    foreach host $list {
		append result {<br> <img src="www.gif"> }
		append result [comanche::html::createSelectNodeURL $host [join [[$nodeManagement getContainer $host] getName]]]
		append result {<br>}
	    }
	} mainServer {
	    append result {<img src="apache_logo.gif"><h1>}
	    append result [mesg::get default_web_server]
	    append result {</h1>}
	    append result {<br>}
	    append result "[mesg::get apache_here_you_can_configure_the] "
	    append result [comanche::html::createShowPropertyPagesURL $node [mesg::get default_web_site_properties]]
	    append result {, }
	    append result [mesg::get {which are also the default for all other virtual servers.}]
	    append result {<br>}
	    append result [mesg::get apache_different_sections]
	    append result {</a>	<br> <img src="folderBig.gif"><b>}
	    append result [mesg::get Directories]
	    append result {</b>	<br>}
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node directory]]] {
		append result  {<br>}
		#append result [mesg::get or_configure_an_existing_one]
		#append result {<br>}
	    } else {
		append result {<br><br>} 
		append result [mesg::get apache_no_directories_defined]
		append result {<br>}
	    }
	    foreach dir $list {
		append result {<br> <img src="closedFolder.gif"> }
		append result [comanche::html::createSelectNodeURL $dir [join [[$nodeManagement getContainer $dir] getName]]]
		append result {<br>}
	    }
	    append result {<br><img src="locationBig.gif"><b>}
	    append result [mesg::get Locations]
	    append result {</b><br>}
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node location]]] {
		append result  {<br>}
		#append result [mesg::get configure_an_existing_one]
		append result {<br>} 
	    } else {
		append result {<br><br> }
		append result [mesg::get apache_no_locations]
		append result {<br>}
	    }
	    foreach loc $list {
		append result {<br> <img src="location.gif"> }
		append result [comanche::html::createSelectNodeURL $loc [join [[$nodeManagement getContainer $loc] getName]]]
		append result {<br>}
	    }
	    append result {
		<br>
		<img src="filesBig.gif"><b>
	    }
	    append result [mesg::get Files]
	    append result {</b><br>}
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node files]]] {
		append result  {<br><br>}
		append result [mesg::get configure_an_existing_one]
		append result {<br>} 
	    } else {
		append result {<br><br> }
		append result [mesg::get apache_no_files]
		append result {<br>}
	    }
	    foreach loc $list {
		append result {<br> <img src="files.gif"> }
		append result [comanche::html::createSelectNodeURL $loc [join [[$nodeManagement getContainer $loc] getName]]]
		append result {<br>}
	    }
	}  directory {
	    append result {<img src="apache_logo.gif"><br><h1>}
	    append result [mesg::get Directory]
	    append result { }
	    append result  [ $container getName ]
	    append result {</h1>
	    <br><br>
	    <img src="folderBig.gif">}
	    append result [mesg::get directory_right_pane]
	    append result [comanche::html::createShowPropertyPagesURL $node [mesg::get here]]
	}  files {
	    append result {<img src="apache_logo.gif"><br><h1>}
	    append result { } 
	    append result [mesg::get Files]
	    append result  [ $container getName ]
	    append result {</h1><br><br><img src="filesBig.gif">}
	    append result [mesg::get files_right_pane]
	    append result [comanche::html::createShowPropertyPagesURL $node [mesg::get here]]	    
	} location {
	    append result {<img src="apache_logo.gif"><br><h1>}
	    append result [mesg::get Location]
	    append result { }
	    append result  [ $container getName ]
	    append result {</h1><br><br><img src="locationBig.gif">}
	    append result [mesg::get location_right_pane]
	    append result [comanche::html::createShowPropertyPagesURL $node [mesg::get here]]	    	    
	} virtualhost {
	    set result {<img src="apache_logo.gif"><h1>}
	    append result [mesg::get Virtual_host]
	    append result { }
	    append result [$container getName]
	    append result	{</h1><br>}
	    append result "[mesg::get apache_here_you_can_configure_the] "
	    append result [comanche::html::createShowPropertyPagesURL $node [mesg::get properties]]
	    append result [mesg::get for_this_virtual_host]
	    append result {.<br>}
	    append result [mesg::get apache_different_sections]
	    append result {</a><br>}
	    append result {<img src="folderBig.gif"><b>}
	    append result [mesg::get Directories]
	    append result {</b> <br>}
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node directory]]] {
		append result  {<br><br>}
		append result [mesg::get configure_an_existing_one]
		append result {<br>} 
	    } else {
		append result {<br><br>}
		append result [mesg::get apache_no_directories_defined]
		append result {<br>}
	    }
	    foreach dir $list {
		append result {<br> <img src="closedFolder.gif"> }
		append result [comanche::html::createSelectNodeURL $dir [join [[$nodeManagement getContainer $dir] getName]]]
		append result {<br>}
	    }
	    append result {<br><img src="locationBig.gif"><b>}
	    append result [mesg::get Locations]
	    append result {</b><br>}
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node location]]] {
		append result  {<br><br>}
		append result [mesg::get configure_an_existing_one]
		append result {<br>} 
	    } else {
		append result {<br><br> }
		append result [mesg::get apache_no_locations]
		append result {<br>}
	    }
	    foreach loc $list {
		append result {<br> <img src="location.gif"> }
		append result [comanche::html::createSelectNodeURL $loc [join [[$nodeManagement getContainer $loc] getName]]]  	
		append result {<br> }
	    }
	    append result {	<br><img src="filesBig.gif"><b>}
	    append result [mesg::get Files]
	    append result {</b><br>}
	    if [string length [set list [$nodeManagement \
		    getPlugInNodeChildrenByNodeName $node files]]] {
		append result  {<br><br>}
		append result [mesg::get configure_an_existing_one]
		append result {<br>} 
	    } else {
		append result {<br><br> }
		append result [mesg::get apache_no_files]
		append result {<br>}
	    }
	    foreach loc $list {
		append result {<br> <img src="files.gif"> }
		append result [comanche::html::createSelectNodeURL $loc [join [[$nodeManagement getContainer $loc] getName]]]  	
		append result {<br>}
	    }
	} default {
	    set result kkk
	}
    }
    return $result
}

# apachePlugIn::_createNodes --
#   Recursive method that explores a configuration document and creates the
# appropriate nodes.

body apachePlugIn::_createNodes { node } {
    switch [ $nodeManagement getNodeName $node] {
	rootNode {
	    set moduleconf [ $nodeManagement addNode  $node\
		    -text [mesg::get server_management] \
		    -openImage wheelSmall.gif\
		    -classList {container apache} \
		    -closedImage wheelSmall.gif\
		    -container [$confDoc getRootContainer]\
		    -nodeName servermanagement ]
	    set servermanagement [ $nodeManagement addNode  $moduleconf\
		    -text [mesg::get module_management] \
		    -openImage moduleManager.gif\
		    -classList {leaf apache} \
		    -closedImage moduleManager.gif\
		    -container [$confDoc getRootContainer]\
		    -nodeName moduleconf ]
	    set serverinfo [ $nodeManagement addNode $moduleconf \
		    -text [mesg::get server_info] \
		    -openImage information.gif\
		    -classList {leaf apache} \
		    -closedImage information.gif\
		    -container [$confDoc getRootContainer]\
		    -nodeName serverinfo ]
	    set logs [ $nodeManagement addNode $moduleconf \
		    -text [mesg::get log_info] \
		    -openImage log.gif\
		    -classList {container apache} \
		    -closedImage log.gif\
		    -container [$confDoc getRootContainer]\
		    -nodeName logs ]
	    foreach fileInfo $logFilesList {
		set filename $fileInfo
		set lognode [ $nodeManagement addNode $logs\
			-text [file tail $filename] \
			-openImage files.gif\
			-classList {leaf apache} \
			-closedImage files.gif\
			-container [$confDoc getRootContainer]\
			-nodeName logfile ]
		array set _mappingLogFiles [list $lognode $filename]
	    }
	    set mainConfigurationNode [$nodeManagement addNode $moduleconf\
		    -text [mesg::get config_info] \
		    -openImage openFolder.gif\
		    -classList {container apache} \
		    -closedImage closedFolder.gif\
		    -container [$confDoc getRootContainer]\
		    -nodeName mainConfigurationNode]
	    foreach filename $configurationFilesList {
		set confnode [ $nodeManagement addNode $mainConfigurationNode \
			-text [file tail $filename] \
			-openImage files.gif\
			-classList {leaf apache} \
			-closedImage files.gif\
			-container [$confDoc getRootContainer]\
			-nodeName conffile ]
		array set _mappingConfigurationFiles [list $confnode $filename]
	    }
	    _createNodes [set mainServer [ $nodeManagement addNode  $node\
		    -text [mesg::get default_web_server] \
		    -openImage mainserver.gif\
		    -classList {container apache} \
		    -closedImage mainserver.gif\
		    -container [$confDoc getRootContainer]\
		    -nodeName mainServer ]]
	} mainServer {
	    foreach container \
		    [$confDoc getContainers [$confDoc getRootContainer]] {
		switch [ $container getClasses ] {
		    directory - location - files {
			_addNode $node $container
		    } virtualhost {
			_createNodes [_addNode $rootNode $container]
		    }
		}
	    }
	} virtualhost {
	    foreach container  [$confDoc getContainers \
		    [$nodeManagement getContainer $node]] {
		_addNode $node $container
	    }
	} directory - location {
	    foreach container  [$confDoc getContainers \
		[$nodeManagement getContainer $node]] {
		_addNode $node $container
	    }
	} limit - servermanagement - files {
	    return
	} default {
	    error "Attempted createNodes unrecognized $node \
		    node name [ $nodeManagement getNodeName $node] "
	}
    }
}


body apachePlugIn::_addNode { node container } {
    switch [$container getClasses] {
	location {
	    $nodeManagement addNode $node\
	            -text [join [$container getName]] \
		    -openImage location.gif\
		    -closedImage location.gif\
		    -classList {container apache} \
		    -container $container\
		    -nodeName location
	} directory {
	    $nodeManagement addNode $node\
	            -text [join [$container getName]] \
		    -openImage closedFolder.gif\
		    -classList {container apache} \
		    -closedImage closedFolder.gif\
		    -container $container\
		    -nodeName directory
	} files {
	    $nodeManagement addNode $node\
	            -text [join [$container getName]] \
		    -openImage files.gif\
		    -classList {leaf apache} \
		    -closedImage files.gif\
		    -container $container\
		    -nodeName files		    
	} virtualhost {
	    $nodeManagement addNode $node\
	            -text [join [$container getName]] \
		    -openImage virtualhost.gif\
		    -classList {container apache} \
		    -closedImage virtualhost.gif\
		    -container $container\
		    -nodeName virtualhost
	}
    }
}


body apachePlugIn::_registerWithNamespace {} {
    global tcl_platform
    set node $rootNode
    set version $serverDescription
    switch $tcl_platform(platform) {
	unix {
	    if [catch {append version " [lrange  [exec $httpd -v] 2 2]"}] {
		append version " Apache/unknown"
	    }
	} windows {
	    global env
	    if [catch {append version " [lrange  \
		    [exec $env(COMSPEC) /c  $httpd -v] 2 2]"}] {
		append version " Apache/unknown"
	    }
	}
    }         
    
    # Now rootNode is no longer root but apache root node
    
    set rootNode [$nodeManagement addNode $node\
	    -text $version \
	    -openImage apache.gif\
	    -closedImage apache.gif\
	    -container {}\
	    -nodeName rootNode]
}


body apachePlugIn::deleteNodeRequest { node } {
     set container [$nodeManagement getContainer $node]
     if ![llength $container] {
       #either main plugin node or mangement
       return
     }
     switch [$container getClasses] {
       virtualhost {
           $confDoc removeContainer [$confDoc getRootContainer]\
	   	   $container
           $nodeManagement removeNode $node
	   _saveConfig         
       } directory - location - files {
           $confDoc removeContainer [$nodeManagement getContainer \
	          [$nodeManagement getParentNode $node]] $container
           $nodeManagement removeNode $node
	   _saveConfig
       }
       default {}
     }
}













