
namespace eval ::apacheparserutils:: {}

proc ::apacheparserutils::loadValue {dirObject value } {
    switch [$dirObject getXuiClass] {
	string - number {
	    if {[$dirObject doYouBelongTo directory] || \
		    [$dirObject doYouBelongTo file] || \
		    [$dirObject doYouBelongTo quoteIfSpace] } { 
		$dirObject setValue [string trim [string trim $value] \"]
	     } else {
	        $dirObject setValue [string trim $value]
	    }
	} choice {
	    $dirObject selectItem [string trim $value]
        } boolean {
	    switch [string tolower [string trim $value]] {
		on - yes - true - 1 {
		   $dirObject setValue
		}
		off - false - no - 0 {
		    $dirObject clearValue
		} default {
		    error "Boolean with value different from on/off"
                }
	    }
	}
    }
}


proc ::apacheparserutils::getOrCreateIfNotExists \
	{directiveName dirDefinition xmlConf currentContainer} {
    if [llength [set existingDir [$xmlConf getDirectiveByName \
            $currentContainer $directiveName]]] {
	if [$existingDir doYouBelongTo unknownDirective] {
	    error
	}
	set xuiObj $existingDir
    } else {
	if [llength [set xuiObj [[$dirDefinition getDirectiveByName \
		$directiveName] clone]]] {
	    # If list, it has by construction the default. Since we are
	    # parsing, we delete that value (we are going to overwrite)
	    if ![string compare [$xuiObj getXuiClass] list] {
	        $xuiObj reset
	    }
	    $xmlConf addDirective $xuiObj $currentContainer
	} else {
	    error
	}
    }
    return $xuiObj
}

proc ::apacheparserutils::loadInComponent { xuiObj name value } {
     ::apacheparserutils::loadValue [$xuiObj getComponentByName $name] $value
}

proc ::apacheparserutils::getElements {text} {
    foreach {element rest} [ ::apacheparserutils::getElement $text] break
    eval lappend result \{$element\}
    while {[string length $rest]} {
	foreach {element rest} [::apacheparserutils::getElement $rest] break
	lappend result $element
    }
    
    # 
    
    return $result
}


proc ::apacheparserutils::getElement { text } {
    set text [string trim $text]
    regexp {(("[^"]*")|([^ ]*)) ?} \
	    $text element
	    
    # There was a problem with things like BrowserMatch, but the problem was
    # not in getElements, but rather that the passed to special case is
    # the text, not the elements! (change the naming in
    # modules/*/specialCase.tcl )

    return [list [string trim $element] \
	    [string range $text [string length $element] end ]]
}








namespace eval ::apache1.3:: {} 


proc ::apache1.3::parseStringList  {elements parser dirDef xmlConf
currentContainer} {

    # Name is lowercase. Hope it works
    
    set xuiObj [apacheparserutils::getOrCreateIfNotExists \
           [string tolower [lindex $elements 0]] \
           $dirDef $xmlConf $currentContainer]
    foreach one [lrange $elements 1 end] {
        set child [$xuiObj newChild]
	$xuiObj insertChild $child
	$child setValue $one
    }
}
						   
proc ::apache1.3::dumpStringList { xuiObj } {
    if ![llength [ $xuiObj getChildren ]] {return}
    set result "[$xuiObj getTagName] "
    foreach child [ $xuiObj getChildren ] {
	append result "[$child getValue] "
    }
    append result "\n"
    return $result
}
				         
