
# apacheDumper --
#   Dumps the XML configuration to httpd.conf
# TO-DO:  This is done in a crude manner.Reuse the existing httpd.conf
# to preserve user comments when possible


class apacheDumper {
    variable specialCaseMapping
    constructor {} {
	array set specialCaseMapping  {}
    }
    method setSpecialCase { procedure args }
    method isSpecialCase { dirName }
    method processContainer { xmlConf container }
    method dump { xmlConf }
    method dumpContainer { xmlConf container }
}

body apacheDumper::isSpecialCase { dirName } {
    return [info exists specialCaseMapping($dirName)]
} 

body apacheDumper::dump { xmlConfDoc } {
   set result [ dumpContainer $xmlConfDoc \
	   [set rootC [$xmlConfDoc getRootContainer]]]
   foreach container [$xmlConfDoc getContainers $rootC] {
	append result [ processContainer $xmlConfDoc $container]
   }
   return $result
}

body apacheDumper::processContainer { xmlConfDoc container } {
    set result {}
    append result "<[$container getClasses] [$container getName]>\n"
    append result [ dumpContainer $xmlConfDoc $container ]
    foreach childContainer [$xmlConfDoc getContainers $container] {
	append result [ processContainer $xmlConfDoc $childContainer]
    }
    append result "</[$container getClasses]>\n"
    return $result
}


body apacheDumper::dumpContainer { xmlConfDoc container } {
    set result {}
    foreach directive [$xmlConfDoc getDirectives $container] {
	set dirName [string tolower [$directive getName]]
	if [isSpecialCase $dirName] {
	    append result "[$specialCaseMapping($dirName) $directive]\n"
	} else {
	    if [$directive doYouBelongTo unknownDirective] {
	        append result "[$directive getValue]\n"
	    } else {
	    switch [$directive getXuiClass] {
		string - number  {
		    set value [$directive getValue] 
		    if [string compare $value [$directive getDefault]] {
		            set value [$directive getText]
			    if {[$directive doYouBelongTo file] || \
			            [$directive doYouBelongTo directory] || \
				    [$directive doYouBelongTo quoteIfSpace] } {
				    if [regexp {\ } $value] {
				        set value "\"$value\""
				    }
			    }	    
			    append result "$dirName $value\n"
			} 
		} boolean {
		    set value [$directive getValue] 
		    if [string compare $value [$directive getDefault]] {
		        switch $value {
			    0 {
			        append result "$dirName off\n"
			    } 1 {
			        append result "$dirName on\n"
			    }
			}
		    }
		} choice {
		    append result \
		           "$dirName [$directive getSelected]\n"
		} default {
		   error "No special case and not recognized in dumping\
		           [$directive getXuiClass] [$directive getName]"
		}
	    }
	   } 
	}
    }
    return $result
}

body apacheDumper::setSpecialCase { procedure args } {
    foreach directive $args {
	set specialCaseMapping([string tolower $directive]) \
		$procedure
    }
}    


