
set currentDir [file dirname [file join [pwd] [info script]]]

mesg::processMesgCatalogDir [file join $currentDir messages]

#source [file join $currentDir specialCases.tcl]
source [file join $currentDir apache.tcl]
source [file join $currentDir apacheModuleManager.tcl]
source [file join $currentDir moduleManagement.tcl]
source [file join $currentDir apacheParser.tcl]
source [file join $currentDir apacheParserUtils.tcl]
#source [file join $currentDir dumper.tcl]
source [file join $currentDir apacheDumper.tcl]
#source [file join $currentDir prettyDumper.tcl]
source [file join $currentDir setup/apacheInstallDialog.tcl]
source [file join $currentDir setup/apacheInstallConfig.tcl]

namespace eval ::apacheplugin:: {
    variable modules
    variable propertypages
    array set modules {}
    array set propertypages {}
    variable disabledModules
    variable disabledModulesFile
    variable apacheplugindir
}
set ::apacheplugin::apacheplugindir [file nativename $currentDir]

# XXX This is a quick hack since it is done globally for all Apache intallations
# Change so it is per-installation

set ::apacheplugin::disabledModulesFile [file join $currentDir disabledModules.conf]
set f [open $::apacheplugin::disabledModulesFile]
set ::apacheplugin::disabledModules [read $f]
close $f


xuiBuilder ::apacheXuiBuilder [list \
	boolean [booleanCreator ::#auto] \
	string [stringCreator ::#auto] \
	structure [structureCreator ::#auto] \
	alternate [alternateCreator ::#auto] \
	choice [choiceCreator ::#auto] \
	list [listCreator ::#auto] \
	group [groupCreator ::#auto] \
	propertyPage [propertyPageCreator ::#auto] \
	propertyPages [propertyPagesCreator ::#auto] \
	dirDefinition [dirDefinitionCreator ::#auto] \
	label [labelCreator ::#auto] \
	number [numberCreator ::#auto] \
	]

proc apache_init {args} {
    array set options $args

    # What is going on here:
    #  Am I in Windows?
    #         Y  -> Do I have any version in the registry?
    #                   Y -> Configure them
    #                        Is there any apache.conf file?
    #                        Y -> continue
    #                        N -> return
    #                   N -> Continue
    #         N -> continue
    # Is there any apache.conf file? If not create
    
    # Instead of having an if-else here for Windows and Unix, it is better
    # To detect the Windows Web Servers when adding servers (to allow 
    # configuration of servers that are not in the registry)
    # Still the problem of creating a management plugIn that manages the rest
    # Should we abstract this in the plugIn management?
    # Not for 1.0
    # For this release, we will create a function that creates plugIns

    # If Windows, look into registry + apache.conf
    # Apache, just apache.conf
    
    global tcl_platform
#    set apacheRootNode [[::plugInUtils::getChildByClass $options(-namespace) \
   root networkServices] getId]
    set apacheRootNode $options(-hookUnderNode)
    #   set apacheRootNode root    
    if {$tcl_platform(platform) == "windows"} {
    
	# Apache docs say only one version can be installed at any given time
	# We consider however multiple version

	# http://dev.scriptics.com/services/support/tclpro/knownbugs.html#IS2
	if {[info exist tcl_platform(isWrapped)]} {
	    load {} Registry
	} else {
	    package require registry
	}
	set prefix [file join \
		HKEY_LOCAL_MACHINE SYSTEM CurrentControlSet Services]
	foreach serviceEntry [registry keys [file nativename $prefix]] {
	    set serviceEntryPrefix [file join $prefix $serviceEntry]
	    if ![catch {registry get [file nativename $serviceEntryPrefix] ImagePath} kk] {
		if [regexp Apache.exe $kk] {
		    set displayName [registry get\
			    [file nativename $serviceEntryPrefix] DisplayName]
		    set configArgs [registry get\
			    [file nativename \
			    [file join $serviceEntryPrefix Parameters]] \
			    ConfigArgs]
		} else {
		    continue
		}
		
		if {[set idx [lsearch -exact $configArgs -f]] != -1} {
		    incr idx
		    set confFile [lindex $configArgs $idx]
		}
		if {[set idx [lsearch -exact $configArgs -d]] != -1} {
		    incr idx
		    set serverRoot [lindex $configArgs $idx]
		}
		set commandList {}
		set httpd {}
		set configurationFiles [helper::fileNativename $confFile]
		set serverDescription $displayName
		return [list [apache_create_plugin -commandList $commandList \
			-serverRoot $serverRoot \
			-configurationFiles $configurationFiles \
			-httpd $httpd -serverDescription $serverDescription\
			-moduledirectory $options(-moduledirectory)\
			-namespace $options(-namespace) \
			-rootNode $apacheRootNode \
			-backupsdir $options(-backupsdir) \
			-apmanager $options(-apmanager)] $serverDescription]
	    }
	}
	return
    }


    set apmanagerXuiPP [::libgui::createXuiFromFile \
	    $::apmanager::installationXMLPrototype]
    
    set doc [dom::newDoc $options(-apachePlugInConfig)]
    ::globalXuiBuilder loadValueFromNode [dom::getElements $doc] $apmanagerXuiPP
    
    #    foreach serverElement [$apmanagerXuiPP.setupApache getChildren] {}
    set serverElement $apmanagerXuiPP
    set httpd  [$serverElement.httpd getValue] 
    set configurationFiles [$serverElement.httpdconf getValue]
    set serverRoot [$serverElement.serverroot getValue] 
    set serverDescription [$serverElement.comment getValue]
    foreach command [$serverElement.commands getChildren] {
	lappend commandList [list [$command.name getValue] [$command.command getValue] [$command.icon getValue]]
    }
    
    if ![file exists $configurationFiles] {
	puts "Configuration file $configurationFiles could not be found. \
		Server ignored"
	error "Configuration file $configurationFiles could not be found. \
		Server ignored"
    }
    if ![file exists $serverRoot] {
	puts "directory $serverRoot could not be found. \
		Server ignored"
	error "directory $serverRoot could not be found. \
		Server ignored"
    }
    
    # Apache module manager
    
    return [list [apache_create_plugin -commandList $commandList \
	    -serverRoot $serverRoot \
	    -configurationFiles $configurationFiles \
	    -httpd $httpd -serverDescription $serverDescription\
	    -moduledirectory $options(-moduledirectory)\
	    -namespace $options(-namespace) -rootNode $apacheRootNode \
	    -backupsdir $options(-backupsdir) -apmanager $options(-apmanager)]\
	    $serverDescription ]
}


proc apache_info {} {
    array set info [list description [mesg::get apache_description]]
    array set info {name {apache}}
    array set info {version {1.0}}
    array set info {icon apache.gif}
    return [array get info]
}
			 
			 
			              
proc apache_create_plugin {args} {

    # We are going to create plugins for different Apache installations
    # To speed up the process, we can share some information between plugins,
    # specially if they belong to the same Apache version, etc.
    # If the location of the module definition is the same, it is safe to assume
    # they are the same version

    # There are some problems, by now do not share

    # We can reuse:
    # directiveDefinition
    # ppDefinition
    # parser
    # dumper
    #
    # Cannot reuse:
    # confDoc



    array set options $args
    set confDoc [confDocument ::#auto]
    set dirDef [dirDefinition ::#auto ]
    apacheXuiBuilder addCreator directiveInclude \
	    [includeCreator ::#auto $dirDef]
    set ppdef [pPDefinition ::#auto ]    
    set ppM [ppManager ::#auto ]  
    set myPg [apachePlugIn ::#auto ]
    set nm [nodeManagement ::#auto $options(-namespace) $myPg]    
    set apModuleManager [apacheModuleManager ::#auto]
    $myPg configure -serverDescription $options(-serverDescription) \
             -rootNode $options(-rootNode) -backupsdir $options(-backupsdir)
    foreach command $options(-commandList) {
	foreach {name execCommand icon} $command break;
	$myPg addNewManagementCommand $name $execCommand $icon
    }
    $myPg configure -httpd  $options(-httpd)
    $myPg configure -configurationFiles $options(-configurationFiles)
    $myPg configure -serverRoot $options(-serverRoot)
    set ap [apacheParser ::#auto $dirDef $confDoc]
    $ap configure -moduleManager $apModuleManager
    set apacheDump [apachePrettyDumper ::#auto]
    $apacheDump configure -moduleManager $apModuleManager
    #set apacheDump [apacheDumper ::#auto]
    
    foreach module [glob -nocomplain [file join $options(-moduledirectory) modules *]] {
	# TO-DO replace this to see if moduleDescription exists
	# catch is for Raven, CVS
	
	splash::add "Loading Apache module [file tail $module]"
	catch { mesg::processMesgCatalogDir [file join $module messages] }
	catch { addModule [file join $module moduleDescription.xml] \
		$dirDef $ppdef $apModuleManager $ap $apacheDump  } kk
	foreach module $::apacheplugin::disabledModules {
	    $apModuleManager disableModule $module
	}
    }
    $ap configure -mainConfFile $options(-configurationFiles)
    $ap configure -includeroot $options(-serverRoot)
    $ap init
    $myPg configure -moduleManager $apModuleManager
    $myPg configure -namespace $options(-namespace) -nodeManagement $nm \
	    -confDoc $confDoc -ppManager $ppM -ppDef $ppdef \
	    -dumper $apacheDump -apmanager $options(-apmanager)
    $myPg _registerWithNamespace
    $myPg init
    return $myPg    
}
