
# Set of procedures for management of Apache modules


# addModule --
# Given a module:
#     add directives
#     add property pages
#     add association property pages  <--> nodes
# 
# Arguments:
#     filename   Filename with the module definition
#     dirDef     Object where to store the directives
#     ppDef      Object where to store the Property pages  
#     moduleManager Object where to store which property pages
#                 correspond to which node, etc
#     parser    Apache parser 
#     dumper    Apache dumper (to add parsing and dumping procedures)

proc addModule {filename dirDef ppDef moduleManager parser dumper} {
    set baseDirectory [file dirname $filename]
    set f [open $filename]
    set xmlDoc [dom::document cget \
	    [dom::DOMImplementation parse [read $f]] -documentElement]
    close $f

    # Get info about the module (name, description, etc)

    set moduleName [ dom::getAttribute $xmlDoc name ]
    $moduleManager addModuleDescription $moduleName [ dom::getAttribute $xmlDoc description ]
    $moduleManager addModuleIcon $moduleName [ dom::getAttribute $xmlDoc icon ]
    set directivesXMLDefinition \
	    [ dom::getAttribute $xmlDoc directivesXMLDefinition ]
    set f [open [file join $baseDirectory $directivesXMLDefinition]]
    set doc [apacheXuiBuilder renderDocument [dom::DOMImplementation \
    parse [read $f]]]
    close $f
    set xuiDirectiveList [$dirDef addDirectiveDefinition $doc]

    set propertyPagesXMLDefinition \
	    [ dom::getAttribute $xmlDoc propertyPagesXMLDefinition ]
    set f [open [file join $baseDirectory $propertyPagesXMLDefinition]]
    set domDoc [dom::DOMImplementation \
    parse [read $f]]
    close $f
    set doc [apacheXuiBuilder renderDocument $domDoc]
    dom::DOMImplementation destroy $domDoc
    $ppDef addPPDefinition $doc
    
    # Iterate 
    #   <nodesInterested> 
    #     <node type="mainserver">
    #       <propertyPage name="newbieBasicMainServer" skillLevel="newbie" />
    #     ...
    
    foreach node [dom::getElements [dom::rp $xmlDoc nodesInterested]] {
    
        # To allow directory,location
    
	foreach nodeType [split [dom::getAttribute $node type] , ] {
	
	foreach ppage [dom::getElements $node] {
	    set ppName [dom::getAttribute $ppage name]
	    set skillLevel [dom::getAttribute $ppage skillLevel]
	    set hookUnder [dom::getAttribute $ppage hookUnder]
	    
	    # If they are empty, do not add them (they will add the 
	    # default)
	    set options {}
	    foreach option {skillLevel hookUnder} {
		if [string length [set $option]] {
		    append options " -$option [set $option] "
		}
	    }
	    eval $moduleManager addPropertyPageNodeRelationship \
		    $moduleName $ppName $nodeType $options
	}
	}
    }
    # Iterate 
    #   <specialCases file="specialCase.tcl">
    #     <specialCase confDir="errorlog"
    #                  xmlDir="errorLog"
    #                  dumper="apache1.3::parseErrorLog"
    #                  parser="apache1.3::dumpErrorLog" />
    #     ...

    set specialCaseNameHttpdConfList {}
    set specialCaseNameXuiDirList {}
    if ![catch {set specialCase [dom::rp $xmlDoc specialCases]} kk] {
	source  [file join $baseDirectory [dom::getAttribute $specialCase file ]]
	foreach node [dom::getElements [dom::rp $xmlDoc specialCases]] {
	    $parser setSpecialCase [dom::getAttribute $node parser] \
		    [dom::getAttribute $node confDir]
	    lappend specialCaseNameHttpdConfList [dom::getAttribute $node parser]
	    $dumper setSpecialCase [dom::getAttribute $node dumper] \
		    [dom::getAttribute $node xmlDir]
	    lappend specialCaseNameXuiDirList [dom::getAttribute $node dumper]
	    
	    if [info exists specialCasesArray([dom::getAttribute $node xmlDir])] {
		append specialCasesArray([dom::getAttribute $node xmlDir]) \
			,[dom::getAttribute $node confDir]
	    } else {
		set specialCasesArray([dom::getAttribute $node xmlDir]) \
			[dom::getAttribute $node confDir]
	    }

	    # Map httpd.conf directive to the xmlDirective to process it
	    # This is necessary for pretty dumping so when we find allow
	    # directives for example we know we have to dump xuiDirective access
	    
	    $dumper setSpecialCaseDirectiveMapping [dom::getAttribute $node xmlDir] \
		    [dom::getAttribute $node confDir]
	    
	}
    } else {
	#puts "No special case $kk"
    }



    # We need to add the directives that will appear in config file
    # This is all special cases httpdconfig + all xuidirs names - xuidirs of special cases
    # (i.e xuiDir access not, allow and deny yes)

    set directiveList {}
    
    foreach one $xuiDirectiveList {
	lappend directiveList [string tolower [$one getName]]
    }

    foreach one $specialCaseNameXuiDirList {
	lremove directiveList [string tolower $one]
    }
    foreach one $specialCaseNameHttpdConfList {
	lappend directiveList $one
    }           

    $moduleManager addModuleDirectivesRelationship $moduleName $directiveList

    # XXX Quick Hack to support module / dirname of all directives
    # Then for each special case we also change (see below)

    foreach xuiDir $xuiDirectiveList {

	# Para cada una pregunta sus special cases y switch 0-> poner nombre
	# mas de uno, separarlo por comas
	
	set xuiDirName [$xuiDir getName]
	if [info exists specialCasesArray($xuiDirName)] {
	    $xuiDir configure -helpReference \
		    "$moduleName=[string tolower $specialCasesArray($xuiDirName)]"
	} else {
	    #puts "$moduleName=[string tolower $xuiDirName]" 
	    $xuiDir  configure -helpReference "$moduleName=[string tolower $xuiDirName]"
	}
    }
}


