namespace eval ::apache1.3:: {}

proc ::apache1.3::parseAccess {elements parser dirDef xmlConf currentContainer} {
    set xuiObj [apacheparserutils::getOrCreateIfNotExists access \
            $dirDef $xmlConf $currentContainer]
    set name [string tolower [lindex $elements 0]]
    if [regexp env [lindex $elements 2] ] {
	set environment 1
	set variable [lindex [split [lindex $elements 2] =] 1]
	set newElement [ $xuiObj newChild ]
	$xuiObj insertChild $newElement
	$subject selectComponentByName env
	$subject.env setValue $variable
    } else {
	foreach host [lrange $elements 2 end ] {
	    set newElement [ $xuiObj newChild ]
	    $xuiObj insertChild $newElement
	    $newElement.action selectItem $name
	    set subject $newElement.subject
	    $subject selectComponentByName host
	    set hostAlternate $subject.host
	    switch $host {
		all {
		    $hostAlternate selectComponentByName all
		} default {
		    $hostAlternate selectComponentByName ipDom
		    $hostAlternate.ipDom setValue $host
		}
	    }
	}
    }
}

proc ::apache1.3::dumpAccess { xuiObj } {
    set result {}
    array set mapping {allow Allow deny Deny}
    foreach child [ $xuiObj getChildren ] {
	append result "$mapping([$child.action getSelected]) from "
	set subject $child.subject
	switch  [$subject getSelectedComponentName] {
	    env {
		append result \
			"env=[[$subject getSelectedComponent] getValue]\n"
	    } host {
		switch [[$subject getSelectedComponent] \
			getSelectedComponentName] {
		    all {
			append result "all\n"
		    } default {
			append result "[[[$subject getSelectedComponent] \
				getSelectedComponent] getValue]\n"
		    }
		}
	    } default {
		error " [$subject getSelectedComponentName] "
	    }
	    
	}
    }
    return $result
}

