namespace eval ::apache1.3:: {}


proc ::apache1.3::parseAlias {elements parser dirDef xmlConf currentContainer} {
    
    set name [string tolower [lindex $elements 0]]
    set origin [lindex $elements 1]
    set destination [lindex $elements 2]
    
    switch $name {
	alias { 
	    set directiveName alias
	    set specific normal
	}
	aliasmatch {
	    set directiveName alias
	    set specific regexp
	} scriptalias {
	    set directiveName scriptAlias
	    set specific normal
	} scriptaliasmatch {
	    set directiveName scriptAlias
	    set specific regexp
	} default {
	    error "unrecognized name $name"
	}
    }
    set xuiObj [apacheparserutils::getOrCreateIfNotExists $directiveName \
    $dirDef $xmlConf $currentContainer]    
    set newElement [ $xuiObj newChild ]
    $xuiObj insertChild $newElement
    $newElement selectComponentByName $specific
    set object [$newElement getComponentByName $specific]
    [$object getComponentByName origin] setValue $origin
    [$object getComponentByName destination] setValue $destination
}

proc ::apache1.3::dumpAlias { xuiObj } {
    set result {}
    foreach child [ $xuiObj getChildren ] {
	switch [$xuiObj getName] {
	    alias {
		switch [[ set dir [$child getSelectedComponent]] getName] {
		    normal {
			set directiveName Alias
		    } regexp {
			set directiveName AliasMatch
		    } default {
			error "Error: alias"
		    }
		}
	    }
	    scriptAlias {
		switch [[ set dir [$child getSelectedComponent]] getName] {
		    normal {
			set directiveName ScriptAlias
		    } regexp {
			set directiveName ScriptaliasMatch
		    } default {
			error "Error: scriptalias"
		    }
		}
	    } default {
		error "Error: this is not supposed. \
			Alias only alias and scriptalias"
	    }
	}
	set origin [[$dir getComponentByName origin] getValue]
	set destination [[$dir getComponentByName destination] getValue]
	if [regexp {\ } $destination] {
	    set destination "\"$destination\""
	}
	append result "$directiveName $origin $destination\n"
    }
    return $result
}

proc ::apache1.3::parseRedirect \
        {text parser dirDef xmlConf currentContainer} {
    set elements ::apacheparserutils::getElements $text	
    set xuiObj [apacheparserutils::getOrCreateIfNotExists redirect \
            $dirDef $xmlConf $currentContainer]
    set name [string tolower [lindex $elements 0]]
    set newChild [$xuiObj newChild]
    if {[llength $elements] == 4} {
        set statusCode [lindex $elements 1]
	switch $statusCode {
	    gone {
	        set statusCode 410
	    } temp {
	        set statusCode 302	    
	    } permanent {
	        set statusCode 301	    
	    } seeother {
	        set statusCode 303	    
	    }
	}
	set elements [lrange $elements 2 end]
    } else {
        set statusCode 302
	set elements [lrange $elements 1 end]
    }
    [$xuiObj getComponentByName statusCode] selectItemByName $statusCode
    set origin [lindex $elements 0]
    set destination [lindex $elements 1]
    switch $name {
	redirect { 
	    set directiveName alias
	    set specific normal
	}
	redirectmatch {
	    set directiveName alias
	    set specific regexp
	}
    }
    switch $
    [$newChild getComponentByName redirect] selectComponentByName $specific
    set object [[$newChild getComponentByName redirect] \
	    getComponentByName $specific]
    [$object getComponentByName origin] setValue $origin
    [$object getComponentByName destination] setValue $destination
    $xuiObj insertChild $newChild

}

proc ::apache1.3::dumpRedirect { xuiObj } {
    set result {}
    foreach child [ $xuiObj getChildren ] {
	switch [[ set dir [[$child getComponentByName redirect] \
		getSelectedComponent]] getName] {
	    normal {
		set directiveName Redirect
	    } regexp {
		set directiveName RedirectMatch
	    } default {
		error "Error: redirect"
	    }
	}
	set origin [[$dir getComponentByName origin] getValue]
		set code [[$child getComponentByName statusCode] getSelected]
	switch $code {
	    default { 
	        set destination {} 
	    } 3* {
	        set destination \
		    [[$dir getComponentByName destination] getValue]
	    }
	}
	append result "$directiveName $code $origin $destination\n"
    }
    return $result
}

