namespace eval ::apache1.3:: {}

proc ::apache1.3::parseAddIcon {elements parser dirDef xmlConf currentContainer} {
    switch [set directive [string tolower [lindex $elements 0]]] {
       addicon {
          set directive addIcon
       } addiconbytype {
          set directive addIconByType
       } addiconbyencoding {
          set directive addIconByEncoding
       }
    }
    set xuiObj [apacheparserutils::getOrCreateIfNotExists $directive \
            $dirDef $xmlConf $currentContainer]
    set child [$xuiObj newChild]
    $xuiObj insertChild $child
    [$child getComponentByName icon] setValue [lindex $elements 1]
    set nameList [$child getComponentByName name] 
    foreach one [lrange $elements 2 end] {
        set nameChild [$nameList newChild]
	$nameList insertChild $nameChild
	$nameChild setValue $one
    }
    
}

proc ::apache1.3::dumpAddIcon { xuiObj } {
    if ![llength [ $xuiObj getChildren ]] {return}
    set result {}
    array set mapping {addicon AddIcon 
       addiconbytype AddIconByType
    addiconbyencoding AddIconByEncoding}
    foreach child [ $xuiObj getChildren ] {
        append result "$mapping([string tolower [$xuiObj getName]]) "
	append result "[[$child getComponentByName icon] getValue] "
	foreach name [[$child getComponentByName name] getChildren] {
	    append result "[$name getValue] "
	}
	append result "\n"
    }
    return $result
}


proc ::apache1.3::parseAddAlt {elements parser dirDef xmlConf currentContainer} {
    switch [set directive [string tolower [lindex $elements 0]]] {
       addalt {
          set directive addAlt
       } addaltbytype {
          set directive addAltByType
       } addaltbyencoding {
          set directive addAltByEncoding
       }
    }
    set xuiObj [apacheparserutils::getOrCreateIfNotExists $directive \
            $dirDef $xmlConf $currentContainer]
    set child [$xuiObj newChild]
    $xuiObj insertChild $child
    [$child getComponentByName alt] setValue \
            [string trim [lindex $elements 1] \"]
    set nameList [$child getComponentByName name] 
    foreach one [lrange $elements 2 end] {
        set nameChild [$nameList newChild]
	$nameList insertChild $nameChild
	$nameChild setValue $one
    }
    
}

proc ::apache1.3::dumpAddAlt { xuiObj } {
    if ![llength [ $xuiObj getChildren ]] {return}
    set result {}
    array set mapping {addalt AddAlt
                       addaltbyttype AddAltByType
		       addaltbyencoding AddAltByEncoding}
    foreach child [ $xuiObj getChildren ] {
        append result "[$xuiObj getName] "
	append result "\"[[$child getComponentByName alt] getValue]\" "
	foreach name [[$child getComponentByName name] getChildren] {
	    append result "[$name getValue] "
	}
	append result "\n"
    }
    return $result
}


proc ::apache1.3::parseIndexIgnore {elements parser dirDef xmlConf currentContainer} {
    set xuiObj [apacheparserutils::getOrCreateIfNotExists indexIgnore \
            $dirDef $xmlConf $currentContainer]
    foreach one [lrange $elements 1 end] {	    
         set child [$xuiObj newChild]
	 $xuiObj insertChild $child
	 $child setValue $one
    }
    
}

proc ::apache1.3::dumpIndexIgnore { xuiObj } {
    if ![llength [ $xuiObj getChildren ]] {return}
    set result "IndexIgnore "
    foreach child [ $xuiObj getChildren ] {
        append result "[$child getValue] "
    }
    append result "\n"
    return $result
}
